% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/foreca-utils.R
\name{foreca-utils}
\alias{biplot.foreca}
\alias{foreca-utils}
\alias{plot.foreca}
\alias{print.foreca}
\alias{summary.foreca}
\title{Plot, summary, and print methods for class 'foreca'}
\usage{
\method{summary}{foreca}(object, lag = 10, alpha = 0.05, ...)

\method{print}{foreca}(x, ...)

\method{biplot}{foreca}(x, ...)

\method{plot}{foreca}(x, lag = 10, alpha = 0.05, ...)
}
\arguments{
\item{lag}{integer; how many lags to test in \code{\link[stats]{Box.test}};
default: \eqn{10}.}

\item{alpha}{significance level for testing white noise in
\code{\link[stats]{Box.test}}; default: \eqn{0.05}.}

\item{...}{additional arguments passed to
\code{\link[stats]{biplot.princomp}}, \code{\link[stats]{biplot.default}},
\code{\link[graphics]{plot}}, or \code{\link[base]{summary}}.}

\item{x,object}{an object of class \code{"foreca"}.}
}
\description{
A collection of S3 methods for estimated ForeCA results
(class \code{"foreca"}).

\code{summary.foreca} computes summary statistics.

\code{print.foreca} prints a human-readable summary in the console.

\code{biplot.foreca} shows a biplot of the ForeCA loadings
(wrapper around \code{\link[stats]{biplot.princomp}}).

\code{plot.foreca} shows biplots, screeplots, and white noise tests.
}
\examples{
# see examples in 'foreca'
}
\keyword{hplot}
\keyword{manip}

