% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whiten.R
\name{whiten}
\alias{whiten}
\alias{check_whitened}
\alias{sqrt_matrix}
\title{whitens multivariate data}
\usage{
whiten(data)

check_whitened(data, check.attribute.only = TRUE)

sqrt_matrix(mat, return.sqrt.only = TRUE, symmetric = FALSE)
}
\arguments{
\item{data}{\eqn{n \times K} array representing \code{n} observations of
\code{K} variables.}

\item{check.attribute.only}{logical; if \code{TRUE} it checks the 
attribute only.  This is much faster (it just needs to look up one attribute
value), but it might not surface silent bugs.  For sake of performance
the package uses the attribute version by default.  However, for 
testing/debugging the full computational version can be used.}

\item{mat}{a square \eqn{K \times K} matrix.}

\item{return.sqrt.only}{logical; if \code{TRUE} (default) it returns only the square root matrix;
if \code{FALSE} it returns other auxiliary results (eigenvectors and
eigenvalues, and inverse of the square root matrix).}

\item{symmetric}{logical; if \code{TRUE} the \code{eigen}-solver assumes
that the matrix is symmetric (which makes it much faster).  This is in particular
useful for a covariance matrix (which is used in \code{whiten}). Default: \code{FALSE}.}
}
\value{
\code{whiten} returns a list with the whitened data, the transformation,
and other useful quantities.

\code{check_whitened} throws an error if the input is not
\code{\link{whiten}}ed, and returns (invisibly) the data with an attribute \code{'whitened'}
equal to \code{TRUE}.  This allows to simply update data to have the
attribute and thus only check it once on the actual data (slow) but then
use the attribute lookup (fast).

\code{sqrt_matrix} returns an \eqn{n \times n}  matrix.  If \eqn{\mathbf{A}}
is not semi-positive definite it returns a complex-valued \eqn{\mathbf{B}}
 (since square root of negative eigenvalues are complex).

If \code{return.sqrt.only = FALSE} then it returns a list with:

\item{values}{eigenvalues of \eqn{\mathbf{A}},}
\item{vectors}{eigenvectors of \eqn{\mathbf{A}},}
\item{sqrt}{square root matrix \eqn{\mathbf{B}},}
\item{sqrt.inverse}{inverse of \eqn{\mathbf{B}}.}
}
\description{
\code{whiten} transforms a multivariate K-dimensional signal \eqn{\mathbf{X}} with mean
\eqn{\boldsymbol \mu_X} and covariance matrix \eqn{\Sigma_{X}} to a \emph{whitened}
signal \eqn{\mathbf{U}} with mean \eqn{\boldsymbol 0} and \eqn{\Sigma_U = I_K}.
Thus it centers the signal and makes it contemporaneously uncorrelated.
See Details.

\code{check_whitened} checks if data has been whitened; i.e., if it has
zero mean, unit variance, and is uncorrelated.

\code{sqrt_matrix} computes the square root \eqn{\mathbf{B}} of a square matrix
\eqn{\mathbf{A}}. The matrix \eqn{\mathbf{B}} satisfies
\eqn{\mathbf{B} \mathbf{B} = \mathbf{A}}.
}
\details{
\code{whiten} uses zero component analysis (ZCA) (aka zero-phase whitening filters)
to whiten the data; i.e., it uses the
inverse square root of the covariance matrix of \eqn{\mathbf{X}} (see
\code{\link{sqrt_matrix}}) as the whitening transformation.
This means that on top of PCA, the uncorrelated principal components are
back-transformed to the original space using the
transpose of the eigenvectors. The advantage is that this makes them comparable
to the original \eqn{\mathbf{X}}.  See References for details.

The \emph{square root} of a quadratic \eqn{n \times n} matrix \eqn{\mathbf{A}}
can be computed by using the eigen-decomposition of \eqn{\mathbf{A}}
\deqn{
 \mathbf{A} = \mathbf{V} \Lambda \mathbf{V}',
}
where \eqn{\Lambda} is an \eqn{n \times n} matrix with the eigenvalues
\eqn{\lambda_1, \ldots, \lambda_n} in the diagonal.
The square root is simply \eqn{\mathbf{B} = \mathbf{V} \Lambda^{1/2} \mathbf{V}'} where
\eqn{\Lambda^{1/2} = diag(\lambda_1^{1/2}, \ldots, \lambda_n^{1/2})}.

Similarly, the \emph{inverse square root} is defined as
\eqn{\mathbf{A}^{-1/2} = \mathbf{V} \Lambda^{-1/2} \mathbf{V}'}, where
\eqn{\Lambda^{-1/2} = diag(\lambda_1^{-1/2}, \ldots, \lambda_n^{-1/2})}
(provided that \eqn{\lambda_i \neq 0}).
}
\examples{

XX <- matrix(rnorm(100), ncol = 2) \%*\% matrix(runif(4), ncol = 2)
cov(XX)
UU <- whiten(XX)$U
cov(UU)
}
\references{
See appendix in \url{http://www.cs.toronto.edu/~kriz/learning-features-2009-TR.pdf}.

See \url{http://ufldl.stanford.edu/wiki/index.php/Implementing_PCA/Whitening}.
}
\keyword{manip}
\keyword{math}
