% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stand_diameters_and_heights.R
\name{d_q}
\alias{d_q}
\title{Quadratic Mean Diameter}
\usage{
d_q(d, n_rep = 1)
}
\arguments{
\item{d}{vector of (stem diameter at breast height) values to calculate the
quadratic mean of}

\item{n_rep}{vector of representation numbers (typically the number of trees
per ha corresponding to the diameter at the same position), will be used
as individual weights for each diameter. If n_rep has length 1, it will be
recycled to the length of d. Otherwise, if the length of n_rep does not
correspond to the length of d, the function will terminate with an error.}
}
\value{
the quadratic mean of d
}
\description{
Function for calculating the quadratic mean of a vector. The typical
application in forestry is to calculate the quadratic mean diameter.
}
\examples{
# Evaluate a sample of equally weighted tree diameters
d_cm <- c(12, 13, 25, 27, 28, 26, 26.1, 32, 35, 31, 42)
d_q(d_cm) # quadratic mean diameter
mean(d_cm) # the arithmetic mean is not the same!

# Assume, the same sample comes from an angle count sample, where each
# tree represents a basal area of 4 m²/ha
n_rep_ha <- 4 / ((d_cm / 100)^2 * pi / 4) # representation number of each tree
d_q(d_cm, n_rep_ha)


# Typical application to a set of single tree data grouped by survey
# time and species
library(dplyr)
oldopt <- options(fe_spec_lang = "eng") # display colloquial species names
# extract the tree data to allow insights into the mechanics
trees <- mm_forest_1_fe_stand_spatial$trees |> filter(!removal)
trees |>
  group_by(species_id, time_yr) |>
  summarise(
    n_ha   = round(sum(n_rep_ha)),
    d_q_cm = d_q(dbh_cm, n_rep_ha)
  ) |>
  print(n = Inf)
options(oldopt) # set species name display to previous value

}
\seealso{
Other stand diameters: 
\code{\link{d_100}()},
\code{\link{d_dom_weise}()}
}
\concept{stand diameters}
