% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_standard_gnfi3.R
\name{h_standard_gnfi3_core}
\alias{h_standard_gnfi3_core}
\title{Core Function for the Estimation of Tree Heights Using the Standard Height
Curve System of the 3rd German National Forest Inventory}
\usage{
h_standard_gnfi3_core(species_id, dbh_cm, d_q_cm, h_q_m, params)
}
\arguments{
\item{species_id}{Vector of species ids (see \code{\link{h_standard_gnfi3}}),
but for this core function to work, \code{species_id} must be provided as
\code{character}. This will and should be not checked inside this function,
because if used as intended, that has happened before calling it. The
codings must either follow the \emph{ger_nfi_2012}, the \emph{tum_wwk_short}, or the
\emph{bavrn_state_short} coding.}

\item{dbh_cm}{Vector of breast height diameters (see
\code{\link{h_standard_gnfi3}})}

\item{d_q_cm}{The species quadratic mean diameter (cm) in the stand of
interest. (see \code{\link{h_standard_gnfi3}})}

\item{h_q_m}{The species mean height (m), corresponding to the quadratic mean
diameter in the stand of interest. (see \code{\link{h_standard_gnfi3}})}

\item{params}{A data frame that defines the function parameters corresponding
to the species coding represented by \code{species_id}}
}
\value{
A vector with estimates of the trees' heights (m) (see
\code{\link{h_standard_gnfi3}})
}
\description{
See documentation of \code{\link{h_standard_gnfi3}} for most information,
this function is the workhorse behind, and should never be called directly by
a user.
}
\details{
The function \code{h_standard_gnfi3} is fully vectorized, inputs are recyled
according to the tibble rules
}
\keyword{internal}
