% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp_diagnostics.R
\name{gp_validate}
\alias{gp_validate}
\title{Automated Gaussian Process Validation}
\usage{
gp_validate(design, response, model, type = "SK", verbose = FALSE)
}
\arguments{
\item{design}{A matrix of \code{n} rows and \code{d} columns.}

\item{response}{A column vector of length \code{n}.}

\item{model}{A GP model of class \code{km} (see \code{\link[DiceKriging]{km-class}}).}

\item{type}{Kriging type: Simple Kriging "SK" or Universal Kriging "UK".}

\item{verbose}{Print the conclusion of the validation?}
}
\value{
A logical. If \code{TRUE} the GP is considered a valid emulator, otherwise further training data will need to be collected to improve the emulator fit.
}
\description{
Automatically validates a Gaussian process (GP) using a separate validation dataset not used in the fitting of the GP.
The Bastos and O'Hagan (2009) empirical fit statistics are used to determine if the GP accurately predicts the validation data.
It then determines roughly whether the model fits well enough.
Currently, it uses the Mahalanobis distance (MD) p-value to determine the GP fit.
}
\examples{
#--- Simple iid Normal Example ---#
# model assumputions hold
set.seed(123)
# training data
x   <- matrix(runif(20,0,1),ncol=1)
y   <- matrix(rnorm(20),ncol = 1)
# validation data
v_x <- matrix(runif(20,-1,1),ncol=1)
v_y <- matrix(rnorm(20),ncol = 1)
my_model    <- DiceKriging::km(formula=~1,
                               design=x,
                               response=y,
                               covtype='matern5_2',
                               optim.method='BFGS',
                               nugget.estim=TRUE)
gp_validate(v_x,v_y,my_model,verbose = TRUE)

#--- Bastos and O'Hagan (2009) Two-input Toy Model ---#
# needs more than 20 training points
set.seed(123)
# training data
x        <- lhs::randomLHS(20,2)
y        <- space_eval(x,bo09_toy)
# validation data
v_x      <- lhs::randomLHS(25,2)
v_y      <- space_eval(v_x,bo09_toy)
my_model    <- DiceKriging::km(formula=~1,
                               design=x,
                               response=y,
                               covtype='matern5_2',
                               optim.method='BFGS',
                               nugget.estim=TRUE)
gp_validate(v_x,v_y,my_model,verbose = TRUE)
}
\references{
Bastos, L. S., & O'Hagan, A. (2009). Diagnostics for gaussian process emulators. Technometrics, 51(4), 425–438, <doi:10.1198/TECH.2009.08019>.
}
