% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/space_fill.R
\name{space_eval}
\alias{space_eval}
\title{Evaluate Design Criterion on LHS}
\usage{
space_eval(lhs, criterion, cluster = NULL)
}
\arguments{
\item{lhs}{A matrix with \code{n} rows and \code{d} columns.}

\item{criterion}{A function with vector input of length \code{d}.}

\item{cluster}{A \code{parallel} cluster object.}
}
\value{
A row vector of length \code{n}.
}
\description{
This function simplifies the evaluation of design criteria on space-filling designs (matrices where each row is a possible design). The design criterion is parallelized as well using the \code{parallel} package. A progress bar gives a visual indicator when the design criterion is expensive.
}
\details{
Only univariate design criteria can be optimized \code{GADGET} currently.
}
\examples{
my_lhs   <- space_fill(c(0,0),c(10,10),20)
dc       <- function(x){sum(x^2)}
response <- space_eval(my_lhs,dc)
print(response) 

}
