% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_pval.R
\name{gene_pval}
\alias{gene_pval}
\title{Estimate a gene-level p-value using Weighted Z-score approach and Meta-analysis with LD correlation coefficients approach}
\usage{
gene_pval(data, db_file, marker_ld, interval, p)
}
\arguments{
\item{data}{A data frame with the results of the association test performed for each marker}

\item{db_file}{A data frame obtained from the import_gff_gtf containing the gtf information}

\item{marker_ld}{A data frame containing the pairwise linkage disequilibrium between markers in a chromosome}

\item{interval}{The interval (in base pairs) used to annotated markers downstream and upstream from the genes coordinates}

\item{p}{The name of the column containing the P-values for each marker}
}
\value{
A data frame with the gene level p-values obtained using the Weighted Z-score approach (P_WZ_ld) and Meta-analysis with LD correlation coefficients approach (P_meta_LD)
}
\description{
Estimate a gene-level p-value using Weighted Z-score approach and Meta-analysis with LD correlation coefficients approach
}
\details{
Requires a table with p-values from a association test, a gtf file file the gene coordinates in the same assembly used to map the variants used in the association study, and a data frame with pairwise linkage disequilibrium (LD) values between markers. This analysis must be performed for each chromosome individually. The data frame with the results of the association study must have three mandatory columns names as CHR, BP and SNP containing the chromosome, base pair position and marker name, respectively. The gtf file must be imported by the import_gff_gtf() function from GALLO or can be customized by the user, since it has the same columns names. The LD table must contain three mandatory columns, SNP_A, SNP_B and R. where, the first two columns must contain the marker names and the third column, the LD value between these markers. This dtaa frame can be obtained using PLINK or any other software which computes pairwise LD between markers in the same chromosome. In the absence of LD values between any two SNPs in the data frame, a LD equal zero is assumed
}
