% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optidisc.R
\name{optidisc}
\alias{optidisc}
\alias{print.optidisc}
\alias{plot.optidisc}
\title{Optimal discretization for continuous variables and visualization.}
\usage{
optidisc(formula, data,
        discmethod = discmethod, discitv = discitv)
\method{print}{optidisc}(x, ...)
\method{plot}{optidisc}(x, ...)
}
\arguments{
\item{formula}{A formula of response and explanatory variables,
where the explanatory variables must be continuous variables to be discretized.}

\item{data}{A data.frame includes response and explanatory variables}

\item{discmethod}{A character vector of discretization methods}

\item{discitv}{A numeric vector of numbers of intervals}

\item{x}{A list of \code{optidisc} result}

\item{...}{Ignore}
}
\description{
Optimal discretization for continuous variables and visualization.
}
\examples{
## set optional discretization methods and numbers of intervals
# optional methods: equal, natural, quantile, geometric, sd and manual
discmethod <- c("equal","quantile")
discitv <- c(4:5)
## optimal discretization
odc1 <- optidisc(NDVIchange ~ Tempchange, ndvi_40, discmethod, discitv)
odc1
plot(odc1)

}
