% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recalibrate.R
\name{recalibrate}
\alias{recalibrate}
\title{recalibrate}
\usage{
recalibrate(
  datadir,
  outputdir,
  use.temp = TRUE,
  spherecrit = 0.3,
  minloadcrit = 72,
  printsummary = TRUE,
  chunksize = c(0.5),
  windowsizes = c(60, 900, 3600)
)
}
\arguments{
\item{datadir}{The location of the directory/file containing GENEActiv binfile.}

\item{outputdir}{The location of the directory/file for the calibrated files to be saved.}

\item{use.temp}{Use temperature sensor data if available (Geneactive only)}

\item{spherecrit}{the minimum required acceleration value (in g) on both sides of 0 g for each
axis. Used to judge whether the sphere is sufficiently populated}

\item{minloadcrit}{the minimum number of hours the code needs to read for the autocalibration
procedure to be effective (only sensitive to multitudes of 12 hrs, other values will be ceiled).
After loading these hours only extra data is loaded if calibration
error has not been reduced to under 0.01 g.}

\item{printsummary}{if TRUE will print a summary when done chunksize number between 0.2 and 1
to specificy the size of chunks to be loaded as a fraction of a 12 hour period, e.g. 0.5 equals 6 hour chunks.
 The default is 1 (12 hrs). For machines with less than 4Gb of RAM memory a value below 1 is recommended.}

\item{chunksize}{number between 0.2 and 1 to specificy the size of chunks to be loaded as a fraction
of a 12 hour period, e.g. 0.5 equals 6 hour chunks. The default is 1 (12 hrs).
For machines with less than 4Gb of RAM memory a value below 1 is recommended.}

\item{windowsizes}{Three values to indicate the lengths of the windows as in c(window1,window2,window3):
window1 is the short epoch length in seconds and by default 5 this is the time window over which
acceleration and angle metrics are calculated, window2 is the long epoch length in seconds for which
non-wear and signal clipping are defined, default 900. However, window3 is the window length of data used
for non-wear detection and by default 3600 seconds. So, when window3 is larger than window2 we use
overlapping windows, while if window2 equals window3 non-wear periods are assessed by non-overlapping
windows.}
}
\value{
Saves a calibrated binfile to an output folder
}
\description{
Taking a GENEActiv binfile and using the recalibration script to create a new calibrated binfile
}
\details{
Takes each binfile found in the data directory, calibrates according to the routine by Vincent T. van Hees
and saves the calibrated file to the specificied output directory
}
\examples{
\dontrun{
DataDirectory = "C:/Users/DataDirectory"
ReCalibrate(DataDirectory)
}
}
