% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelopes2d.r
\name{plot.combined_global_envelope2d}
\alias{plot.combined_global_envelope2d}
\title{Plotting function for combined 2d global envelopes}
\usage{
\method{plot}{combined_global_envelope2d}(
  x,
  fixedscales = 2,
  labels,
  what = c("obs", "lo", "hi", "lo.sign", "hi.sign"),
  sign.col = "red",
  transparency = 155/255,
  digits = 3,
  ...
)
}
\arguments{
\item{x}{A 'global_envelope' object for two-dimensional functions}

\item{fixedscales}{0, 1 or 2. See details.}

\item{labels}{A character vector of suitable length giving the labels for the separate plots.
Default exists. This parameter allows replacing the default.}

\item{what}{Character vector specifying what information should be plotted for 2d functions.
A combination of:
Observed (\code{"obs"}), upper envelope (\code{"hi"}), lower envelope (\code{"lo"}),
observed with significantly higher values highlighted (\code{"hi.sign"}),
observed with significantly lower values highlighted (\code{"lo.sign"}).}

\item{sign.col}{The color for the observed curve when outside the global envelope
(significant regions). Default to "red". Setting the color to \code{NULL} corresponds
to no coloring.}

\item{transparency}{A number between 0 and 1 (default 155/255, 60% transparency).
Similar to alpha of \code{\link[grDevices]{rgb}}. Used in plotting the significant regions for 2d
functions.}

\item{digits}{The number of digits used for printing the p-value or p-interval
in the default main.}

\item{...}{Ignored.}
}
\description{
If fixedscales is FALSE (or 0) all images will have separate scale.
If fixedscales is TRUE (or 1) each x[[i]] will have a common scale.
If fixedscales is 2 all images will have common scale.
}
\examples{
data(abide_9002_23)

res <- graph.flm(nsim = 19, # Increase nsim for serious analysis!
                 formula.full = Y ~ Group + Sex + Age,
                 formula.reduced = Y ~ Sex + Age,
                 curve_sets = list(Y = subset(abide_9002_23[['curve_set']], 1:50)),
                 factors = abide_9002_23[['factors']][1:50,],
                 contrasts = FALSE,
                 GET.args = list(type = "area"))
plot(res)
plot(res, what=c("obs", "hi"))

plot(res, what=c("hi", "lo"), fixedscales=1)

plot(res, what=c("obs", "lo", "hi"), fixedscales=FALSE)

if(requireNamespace("gridExtra", quietly=TRUE)) {
  # Edit style of "fixedscales = 2" plots
  plot(res, what=c("obs", "hi")) + ggplot2::theme_minimal()
  plot(res, what=c("obs", "hi")) + ggplot2::theme_bw()

  # Edit style (e.g. theme) of "fixedscales = 1 or 0" plots
  gs <- lapply(res, plot, what=c("obs", "hi"), main="")
  gridExtra::grid.arrange(grobs=gs, ncol=1, top="My main")

  gs <- outer(res, c("obs", "hi"), FUN=Vectorize(function(res, what)
    list(plot(res, what=what, main="") + ggplot2::theme(axis.ticks=ggplot2::element_blank(),
      axis.text=ggplot2::element_blank(), axis.title=ggplot2::element_blank()))))
  gridExtra::grid.arrange(grobs=t(gs))
}
}
