% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GE_translate_inputs.R
\name{GE_translate_inputs}
\alias{GE_translate_inputs}
\title{GE_translate_inputs.R}
\usage{
GE_translate_inputs(beta_list, rho_list, prob_G, cov_Z = NULL, cov_W = NULL,
  corr_G = NULL)
}
\arguments{
\item{beta_list}{A list of the effect sizes in the true model.
Use the order beta_0, beta_G, beta_E, beta_I, beta_Z, beta_M.
If G or Z or M is a vector, then beta_G/beta_Z/beta_M should be vectors.
If Z and/or M/W do not exist in your model, then set beta_Z and/or beta_M = 0.}

\item{prob_G}{Probability that each allele is equal to 1.  Since each SNP has
two alleles, the expectation of G is 2*prob_G.}

\item{cov_Z}{Should be a matrix equal to cov(Z) or NULL if no Z.}

\item{cov_W}{Should be a matrix equal to cov(W) or NULL if no W.}

\item{corr_G}{Should be a matrix giving the *pairwise correlations* between each SNP
in the set, or NULL. Must be specified if G is a vector.  For example, the [2,3] element
of the matrix would be the pairwise correlation between SNP2 and SNP3. Diagonal
should be 1.}

\item{cov_list}{A list of expectations (which happen to be covariances if all covariates
are centered at 0) in the order specified by GE_enumerate_inputs().
If Z and/or M/W do not exist in your model, then treat them as constants 0. For example,
if Z doesn't exist and W includes 2 covariates, then set cov(EZ) = 0 and cov(ZW) = (0,0).
If describing expectations relating two vectors, i.e. Z includes two covariates and W
includes three covariates, sort by the first term and then the second. Thus in the 
example, the first three terms of cov(ZW) are cov(Z_1,W_1),cov(Z_1,W_2), cov(Z_1,W_3), 
and the last three terms are cov(Z_3,W_1), cov(Z_3,W_2), cov(Z_3,W_3).}
}
\value{
A list with the elements:
\item{sig_mat_total}{The sigma parameter for rmvnorm call to generate our data.}
}
\description{
Mostly for internal use, function called by GE_bias_normal() and GE_scoreeq_sim()
to translate the rho_list inputs and return a total covariance matrix for simulation/
checking validity of covariance structure.  If invalid covariance structure, will stop
and return an error message.
}
\examples{
GE_translate_inputs( beta_list=as.list(runif(n=6, min=0, max=1)),
rho_list=as.list(rep(0.3,6)), prob_G=0.3, cov_Z=1, cov_W=1)
}
\keyword{internal}

