% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDR_control.R
\name{gforce.FDR_control}
\alias{gforce.FDR_control}
\title{FDR Control Procedure.}
\usage{
gforce.FDR_control(test_stats, alpha, procedure = "BY")
}
\arguments{
\item{test_stats}{\eqn{d x d} symmetric matrix of test statistics.}

\item{alpha}{alpha level for the FDR control procedure.}

\item{procedure}{a string. \code{procedure == 'BY'} indicates to use the Benjamini-Yekutieli thresholding rule.
\code{procedure == 'BH'} indicates to use the Benjamini-Hochberg thresholding rule.}
}
\value{
An object with following components
\describe{
\item{\code{reject_null}}{\eqn{d x d} upper triangular matrix. \code{TRUE} entries indicate the null hypothesis should be rejected.}
\item{\code{R_tau_hat}}{an integer. Indicates the number of hypotheses rejected.}
\item{\code{tau_hat}}{a real number. Indicates a threshold above which the null hypothesis is rejected.}
\item{\code{num_hypotheses}}{an integer. Indicates the number of hypotheses tested.}
}
}
\description{
Performs by default the Benjamini-Yekutieli FDR control procedure. Optionally, the Benjamini-Hochberg thresholding
rule can be used instead. As input it takes a symmetric matrix of test statistics with standard normal null
distributions. The number of hypotheses tested is \eqn{d(d-1)/2}.
}
\references{
Y. Benjamini and Y. Hochberg. Controlling the False Discovery Rate: A Practical and Powerful Approach to Multiple Testing.
            \emph{Journal of the Royal Statistical Society}, 1995.

Y. Benjamini and D. Yekutieli. The Control of the False Discovery Rate in Multiple Testing Under Dependency.
            \emph{The Annals of Statistics}, 2001.
}
