% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gotermlevel.R
\name{GOTermBPOnLevel}
\alias{GOTermBPOnLevel}
\title{GO biological process (BP) terms level getter}
\usage{
GOTermBPOnLevel(goterm)
}
\arguments{
\item{goterm}{An object of class character. A character string of GO biological process (BP) term id.
The object can be a GO-term or a vector of GO-terms}
}
\value{
A two-column matrix of the GO-terms and the level they map to
}
\description{
Gets the level of a GO biological process (BP) term based on the directed acyclic graph (DAG).
}
\note{
The Gene Ontology (GO) biological process (BP) tree was built using the root node "GO:0001850"
}
\examples{
# A vector of biological process GO terms
goterms <- c("GO:0006805","GO:0009083","GO:0006631","GO:0006629")

GOTermBPOnLevel(goterms)

GOTermBPOnLevel("GO:0055114")
}
