% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degreeDistMF.R
\name{Level2NoLeafNodeMF}
\alias{Level2NoLeafNodeMF}
\title{Non-leaf GO-terms on a GO MF level}
\usage{
Level2NoLeafNodeMF(level, organism = NULL)
}
\arguments{
\item{level}{A numeric value for the GO-level}

\item{organism}{The organism of interest from the list of supported organism. If null the results are from the general GO-DAG (default)}
}
\value{
A set of non-leaf GO-terms
}
\description{
This function returned all the non-leaf GO-terms on a particular GO MF level that are not. The supported
             organisms are "Homo sapiens / Human", "Rattus norvegicus / Rat", "Mus musculus / Mouse", "Danio rerio / Zebrafish",
             "Caenorhabditis elegans / Worm" ,"Arabidopsis thaliana / Cress", "Saccharomyces cerevisiae / Yeast",
             "Schizosaccharomyces pombe / Fission yeast", "Drosophila melanogaster / Fruit fly", "Escherichia coli / E.coli".
}
\examples{
# Non-leaf nodes on level 15
Level2NoLeafNodeMF(15)

# Non-leaf nodes from level 10 for Rat MF GO-DAG
Level2NoLeafNodeMF(10, "Rat")
}
