% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp.functions6.R
\name{gprPredict}
\alias{gprPredict}
\title{Prediction using Gaussian Process}
\usage{
gprPredict(
  train = NULL,
  input.new = NULL,
  noiseFreePred = F,
  hyper = NULL,
  input = NULL,
  Y = NULL,
  mSR = NULL,
  Cov = NULL,
  gamma = NULL,
  nu = NULL,
  meanModel = 0,
  mu = 0
)
}
\arguments{
\item{train}{A 'gpr' object obtained from 'gpr' function. Default to NULL. If
NULL, learning is done based on the other given arguments; otherwise,
prediction is made based on the trained model of class gpr'.}

\item{input.new}{Test input covariates.  It must be either a matrix, where
each column represents a covariate, or a vector if there is only one
covariate.}

\item{noiseFreePred}{Logical. If TRUE, predictions will be noise-free.}

\item{hyper}{The hyperparameters. Default to NULL. If not NULL, then it must
be a list with appropriate names.}

\item{input}{Input covariates. It must be either a matrix, where each column
represents a covariate, or a vector if there is only one covariate.}

\item{Y}{Training response. It should be a matrix, where each column is a
realisation. It can be a vector if there is only one realisation.}

\item{mSR}{Subset size m if Subset of Regressors method is used for
prediction. It must be smaller than the total sample size.}

\item{Cov}{Covariance function(s) to use. Options are: 'linear', 'pow.ex',
'rat.qu', and 'matern'. Default to 'power.ex'.}

\item{gamma}{Power parameter used in powered exponential kernel function. It
must be 0<gamma<=2.}

\item{nu}{Smoothness parameter of the Matern class. It must be a positive
value.}

\item{meanModel}{Type of mean function. It can be \describe{ \item{0}{Zero
mean function} \item{1}{Constant mean function to be estimated}
\item{'t'}{Linear model for the mean function} \item{'avg'}{The average
across replications is used as the mean function. This is only used if
there are more than two realisations observed at the same input coordinate
values.} } Default to 0. If argument 'mu' is specified, then 'meanModel'
will be set to 'userDefined'.}

\item{mu}{Mean function specified by the user. It must be a vector. Its
length must be the same as the sample size, that is, nrow(response).}
}
\value{
A list containing  \describe{ \item{pred.mean}{Mean of predictions}
  \item{pred.sd}{Standard deviation of predictions} \item{newdata}{Test input 
  data}
  \item{noiseFreePred}{Logical. If TRUE, predictions are noise-free.}
  \item{...}{Objects of 'gpr' class. } }
}
\description{
Prediction using Gaussian Process
}
\examples{
## See examples in vignettes:

# vignette("gpr_ex1", package = "GPFDA")
# vignette("gpr_ex2", package = "GPFDA")
# vignette("co2", package = "GPFDA")
}
