/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.threading;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.usadellab.trimmomatic.TrimStats;
import org.usadellab.trimmomatic.fastq.FastqRecord;
import org.usadellab.trimmomatic.threading.BlockOfRecords;
import org.usadellab.trimmomatic.threading.TrimLogRecord;
import org.usadellab.trimmomatic.trim.Trimmer;
import org.usadellab.trimmomatic.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockOfWork
implements Callable<BlockOfRecords> {
    private Logger logger;
    private Trimmer[] trimmers;
    private BlockOfRecords bor;
    private boolean pe;
    private boolean trimLog;

    public BlockOfWork(Logger logger, Trimmer[] trimmers, BlockOfRecords bor, boolean pe, boolean trimLog) {
        this.logger = logger;
        this.trimmers = trimmers;
        this.bor = bor;
        this.pe = pe;
        this.trimLog = trimLog;
    }

    private TrimLogRecord makeTrimLogRec(FastqRecord rec, FastqRecord originalRec) {
        int length = 0;
        int startPos = 0;
        int endPos = 0;
        int trimTail = 0;
        if (rec != null) {
            length = rec.getSequence().length();
            startPos = rec.getHeadPos();
            endPos = length + startPos;
            trimTail = originalRec.getSequence().length() - endPos;
        }
        return new TrimLogRecord(originalRec.getName(), length, startPos, endPos, trimTail);
    }

    @Override
    public BlockOfRecords call() throws Exception {
        TrimStats stats = new TrimStats();
        if (this.pe) {
            List<FastqRecord> originalRecs1 = this.bor.getOriginalRecs1();
            List<FastqRecord> originalRecs2 = this.bor.getOriginalRecs2();
            int len1 = originalRecs1.size();
            int len2 = originalRecs2.size();
            if (len1 == 0 && len2 == 0) {
                ArrayList<List<FastqRecord>> trimmedRecs = new ArrayList<List<FastqRecord>>();
                for (int i = 0; i < 4; ++i) {
                    trimmedRecs.add(null);
                }
                this.bor.setTrimmedRecs(trimmedRecs, null);
                return this.bor;
            }
            int len = len1 < len2 ? len1 : len2;
            FastqRecord[] originalRecs = new FastqRecord[2];
            ArrayList<FastqRecord> trimmedRecs1P = new ArrayList<FastqRecord>();
            ArrayList<FastqRecord> trimmedRecs1U = new ArrayList<FastqRecord>();
            ArrayList<FastqRecord> trimmedRecs2P = new ArrayList<FastqRecord>();
            ArrayList<FastqRecord> trimmedRecs2U = new ArrayList<FastqRecord>();
            ArrayList<TrimLogRecord> trimLogList = null;
            if (this.trimLog) {
                trimLogList = new ArrayList<TrimLogRecord>();
            }
            for (int i = 0; i < len; ++i) {
                originalRecs[0] = originalRecs1.get(i);
                originalRecs[1] = originalRecs2.get(i);
                FastqRecord[] recs = originalRecs;
                for (int j = 0; j < this.trimmers.length; ++j) {
                    try {
                        recs = this.trimmers[j].processRecords(recs);
                        continue;
                    }
                    catch (RuntimeException e) {
                        this.logger.errorln("Exception processing reads: " + originalRecs[0].getName() + " and " + originalRecs[1].getName());
                        throw e;
                    }
                }
                if (recs[0] != null && recs[1] != null) {
                    trimmedRecs1P.add(recs[0]);
                    trimmedRecs2P.add(recs[1]);
                } else if (recs[0] != null) {
                    trimmedRecs1U.add(recs[0]);
                } else if (recs[1] != null) {
                    trimmedRecs2U.add(recs[1]);
                }
                stats.logPair(originalRecs, recs);
                if (!this.trimLog) continue;
                if (originalRecs[0] != null) {
                    trimLogList.add(this.makeTrimLogRec(recs[0], originalRecs[0]));
                }
                if (originalRecs[1] == null) continue;
                trimLogList.add(this.makeTrimLogRec(recs[1], originalRecs[1]));
            }
            ArrayList<List<FastqRecord>> trimmedRecsList = new ArrayList<List<FastqRecord>>();
            trimmedRecsList.add(trimmedRecs1P);
            trimmedRecsList.add(trimmedRecs1U);
            trimmedRecsList.add(trimmedRecs2P);
            trimmedRecsList.add(trimmedRecs2U);
            this.bor.setTrimmedRecs(trimmedRecsList, trimLogList);
            this.bor.setStats(stats);
        } else {
            List<FastqRecord> originalRecsL = this.bor.getOriginalRecs1();
            int len = originalRecsL.size();
            if (len == 0) {
                ArrayList<List<FastqRecord>> trimmedRecs = new ArrayList<List<FastqRecord>>();
                for (int i = 0; i < 4; ++i) {
                    trimmedRecs.add(null);
                }
                this.bor.setTrimmedRecs(trimmedRecs, null);
                return this.bor;
            }
            FastqRecord[] originalRecs = new FastqRecord[1];
            ArrayList<FastqRecord> trimmedRecs = new ArrayList<FastqRecord>();
            ArrayList<TrimLogRecord> trimLogList = null;
            if (this.trimLog) {
                trimLogList = new ArrayList<TrimLogRecord>();
            }
            for (int i = 0; i < len; ++i) {
                originalRecs[0] = originalRecsL.get(i);
                FastqRecord[] recs = originalRecs;
                for (int j = 0; j < this.trimmers.length; ++j) {
                    try {
                        recs = this.trimmers[j].processRecords(recs);
                        continue;
                    }
                    catch (RuntimeException e) {
                        this.logger.errorln("Exception processing read: " + originalRecs[0].getName());
                        e.printStackTrace();
                        throw e;
                    }
                }
                if (recs[0] != null) {
                    trimmedRecs.add(recs[0]);
                }
                stats.logPair(originalRecs, recs);
                if (!this.trimLog || originalRecs[0] == null) continue;
                trimLogList.add(this.makeTrimLogRec(recs[0], originalRecs[0]));
            }
            ArrayList<List<FastqRecord>> trimmedRecsList = new ArrayList<List<FastqRecord>>();
            trimmedRecsList.add(trimmedRecs);
            this.bor.setTrimmedRecs(trimmedRecsList, trimLogList);
            this.bor.setStats(stats);
        }
        return this.bor;
    }
}

