% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noise_injectors.R
\name{noiseInjector.dummy}
\alias{noiseInjector.dummy}
\title{Noise Injector dummy function}
\usage{
noiseInjector.dummy(phenotypes)
}
\arguments{
\item{phenotypes}{input phenotypes. This object will be returned without checks.}
}
\value{
the same passed \code{phenotypes}
}
\description{
This noise injector does not add any noise. Passed \code{phenotypes} are
simply returned. This function is useful when comparing different
regressors on the same dataset without the effect of extra injected noise.
}
\examples{
phenos = rnorm(10)
all(phenos == noiseInjector.dummy(phenos)) #TRUE
}
\seealso{
Other noiseInjectors: \code{\link{noiseInjector.norm}},
  \code{\link{noiseInjector.swapper}},
  \code{\link{noiseInjector.unif}}
}
\concept{noiseInjectors}
