% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.r
\name{ICCplot}
\alias{ICCplot}
\title{Plot ICC or OCC}
\usage{
ICCplot(
  fit,
  selected_item,
  theta = seq(-4, 4, 0.1),
  plot.occ = FALSE,
  addlabel = FALSE,
  base_size = 16,
  line_size = 1,
  cal_option = "D"
)
}
\arguments{
\item{fit}{an object from \code{\link{runGRM}}}

\item{selected_item}{a numeric indicating for what items the function makes plots}

\item{theta}{a numeric indicating latent traits}

\item{plot.occ}{a logical. If TRUE, OCC is made instead of ICC}

\item{addlabel}{a logical indicating whether to add the b parameter as labels}

\item{base_size}{a numeric indicating the base font size}

\item{line_size}{a numeric indicating the size of line}

\item{cal_option}{a character indicating the plot color specified in
\code{\link{scale_color_viridis_d}} (default = \code{D})}
}
\value{
a \code{\link{ggplot}} object.
}
\description{
Plot ICC or OCC
}
\details{
This makes either item characteristic curve plots or
operating characteristic curve plots
}
\examples{

grm_dt <- genData(eta = genTheta(nsample = 500, nfac = 1),
                 ipar = genIRTpar(nitem = 10, ncat = 3, nfac = 1))

fit <- runGRM(dat = grm_dt,
            lav.syntax = genLavSyn(dat = grm_dt, nfac = 1),
            estimator = "WL")
ICCplot(fit, 1, seq(-3, 3, .1), plot.occ = FALSE, base_size = 16)

}
