% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateESpath.R
\name{calculateESpath}
\alias{calculateESpath}
\title{Calculation of Effects Sizes and their variance for the different Gene Sets
and studies}
\usage{
calculateESpath(
  objectMApath,
  measure = c("limma", "SMD", "MD"),
  WithinVarCorrect = TRUE,
  missAllow = 0.3
)
}
\arguments{
\item{objectMApath}{A list of list. Each list contains two elements.
The first element is the Gene Set matrix (gene sets in rows and samples in
columns) and the second element is a vector of zeros and ones that represents
the state of the different samples of the Gene Sets matrix.
0 represents one group (controls) and 1 represents the other group (cases).}

\item{measure}{A character string that indicates the type of effect size to
be calculated. The options are "limma", "SMD" and "MD". The default value
is "limma". See details for more information.}

\item{WithinVarCorrect}{A logical value that indicates if the within variance
correction should be applied. The default value is TRUE. See details for more
information.}

\item{missAllow}{a number that indicates the maximum proportion of missing
values allowed in a sample. If the sample has more proportion of missing
values the sample will be eliminated. In the other case the missing values
will be imputed using the K-NN algorithm.}
}
\value{
A list formed by two elements:
\itemize{
\item{First element (ES) is a dataframe were columns are each of the studies
(datasets) and rows are the genes sets. Each element of the dataframe
represents the Effect Size.}
\item{Second element (Var) is a dataframe were columns are each of the
studies (datasets) and rows are the genes sets. Each element of the dataframe
represents the variance of the Effect size.}
}
}
\description{
This function uses different estimators to calculate the different effects
size and their variance for each gene and for each dataset
}
\details{
The different estimator methods that can be applied are:
\enumerate{
   \item "limma"
   \item "SMD"
   \item "MD"
}

The \bold{"SMD"} (Standardized mean different) method calculates the effect
size using the Hedges'g estimator (Hedges, 1981).

The \bold{"MD"} (raw mean different) calculates the effects size as the
difference between the means of the two groups (Borenstein, 2009).

The \bold{"limma"} method used the limma package to calculate the effect size
and the variance of the effect size. The effect size is calculated from the
moderated Student's t computed by limma. From it, the estimator of Hedges'g
and its corresponding variance are obtained based on 
(Rosenthal, R., & Rosnow, R. L., 2008))
In this way, some of the false positives obtained by 
the "SMD" method are reduced.

The \bold{WithinVarCorrect} parameter is a logical value that indicates if
the within variance correction should be applied. In the case of applying
the correction, the variance of the gene sets in each of the studies is
calculated based on the mean of the estimators and not on the estimator of
the study itself as described in formula (21) by (Lin L and Aloe AM 2021.)
}
\examples{

data("simulatedData")
calculateESpath(objectMApath = objectMApathSim, measure = "limma")

}
\references{
Borenstein, M. (2009). Effect sizes for continuous data. In H. Cooper,
L. V. Hedges, & J. C. Valentine (Eds.),
The handbook of research synthesis and meta-analysis (2nd ed., pp. 221–235).
New York: Russell Sage Foundation.

Hedges, L. V. (1981). Distribution theory for Glass's estimator of effect
size and related estimators. Journal of Educational Statistics, 6(2),
107–128. \doi{doi:10.2307/1164588}

Lin L, Aloe AM (2021). Evaluation of various estimators for standardized mean
difference in meta-analysis. Stat Med. 2021 Jan 30;40(2):403-426.
\doi{10.1002/sim.8781}

Rosenthal, R., & Rosnow, R. L. (2008). Essentials of behavioral research:
Methods and data analysis. McGraw-Hill.
}
\seealso{
\code{\link{createObjectMApath}}
}
\author{
Juan Antonio Villatoro Garcia,
\email{juanantoniovillatorogarcia@gmail.com}
}
