% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsnSubnetSummary.R
\name{gsnSubnetSummary}
\alias{gsnSubnetSummary}
\title{gsnSubnetSummary}
\usage{
gsnSubnetSummary(
  object,
  pathways.data = NULL,
  distance = NULL,
  id_col = NULL,
  stat_col = NULL,
  sig_order = NULL,
  stat_col_2 = NULL,
  sig_order_2 = NULL,
  summary_statistics = c("hm", "min_max"),
  seed_gs_fields = NULL
)
}
\arguments{
\item{object}{A GSNData data object containing a distance matrix and subnets data. If pathways
data is not specified by the pathways.data argument (described below), the object must contain
imported pathways data as well.}

\item{pathways.data}{An (optional) data.frame containing pathways data (GSEA, CERNO, GSNORA, etc.)
with 1 or 2 associated statistical columns, typically \emph{P}-values, specified by stat_col and
stat_col_2 below.}

\item{distance}{A distance metric with associated subnets data.}

\item{id_col}{(optional) This is the name of the column in the pathways data.frame that corresponds
to the names of gene sets. The default value is specified by \code{object$pathways$id_col}.
(See details.)}

\item{stat_col}{(optional) Specifies the name of the first statistical column, if not specified,
defaults to the value in \code{object$pathways$stat_col}.}

\item{sig_order}{(optional) This indicates the behavior of \code{stat_col}, whether low values
(\code{'loToHi'}) or high values (\code{'hiToLo'}) are most significant. The default value is
specified in \code{object$pathways$sig_order}.}

\item{stat_col_2}{(optional) Specifies the name of the second statistical column, if not specified,
defaults to the value in \code{object$pathways$stat_col_2}.}

\item{sig_order_2}{(optional) This indicates the behavior of \code{stat_col_2}, whether low values
(\code{'loToHi'}) or high values (\code{'hiToLo'}) are most significant. The default value is
specified in \code{object$pathways$sig_order_2}.}

\item{summary_statistics}{(optional) A character vector specifying which summary statistics are
to be calculated from the 'stat_col'. Acceptable values include 'hm' specifying harmonic mean,
'min_max', specifying either minimum or maximum depending on \code{sig_order}, or the name of
a function. (default: \code{c('hm', 'min_max')})}

\item{seed_gs_fields}{(optional) A character vector specifying the names of additional seed gene
set fields to retain from pathways data.}
}
\value{
A data.frame with a statistical summary of subnets.
}
\description{
Generates a table summarizing subnets that incorporates subnets and pathways data.
}
\details{
The output data.frame contains a list of subnets, each with an associated list of gene
set IDs. For each subnet, summary statistics are calculated, including the harmonic mean of
\code{stat_col} and (if specified) \code{stat_col_2}. In addition, the minimum or maximum of the
\code{stat_col} and \code{stat_col_2} is calculated, depending on the \code{sig_order} and
\code{sig_order_2}. For \code{loToHi}, the minimum is calculated, and for \code{hiToLo}, the
maximum.
}
\examples{

library(GSNA)

# In this example, we generate a gene set network from CERNO example
# data. We begin by subsetting the CERNO data for significant results:
sig_pathways.cerno <- subset( Bai_CiHep_DN.cerno, adj.P.Val <= 0.05 )

# Now create a gene set collection containing just the gene sets
# with significant CERNO results, by subsetting Bai_gsc.tmod using
# the gene set IDs as keys:
sig_pathways.tmod <- Bai_gsc.tmod[sig_pathways.cerno$ID]

# And obtain a background gene set from differential expression data:
background_genes <- toupper( rownames( Bai_CiHep_v_Fib2.de ) )

# Build a gene set network:
sig_pathways.GSN <-
   buildGeneSetNetworkJaccard(geneSetCollection = sig_pathways.tmod,
                              ref.background = background_genes )

# Now import the CERNO data:
sig_pathways.GSN <- gsnImportCERNO( sig_pathways.GSN,
                                    pathways_data = sig_pathways.cerno )

# Now we can pare the network and assign subnets:
sig_pathways.GSN <- gsnPareNetGenericHierarchic( object = sig_pathways.GSN )
sig_pathways.GSN <- gsnAssignSubnets(  object = sig_pathways.GSN )

# Now, get a statistacal summary of the subnets:
gsnSubnetSummary( sig_pathways.GSN )

}
