% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimHMMGaussianInv.R
\name{SimHMMGaussianInv}
\alias{SimHMMGaussianInv}
\title{Simulation of a univariate Gaussian Hidden Markov Model (HMM)}
\usage{
SimHMMGaussianInv(u, mu, sigma, Q, eta0)
}
\arguments{
\item{u}{series of uniform i.i.d. series (n x 1);}

\item{mu}{vector of means for each regime (r x 1);}

\item{sigma}{vector of standard deviations for each regime (r x 1);}

\item{Q}{Transition probality matrix (r x r);}

\item{eta0}{Initial value for the regime;}
}
\value{
\item{x}{Simulated Data}

\item{eta}{Probability of regimes}
}
\description{
Generates a univariate regime-switching random walk with Gaussian regimes starting from a given state eta0, using the inverse method from noise u.Can be useful when generating multiple time series.
}
\examples{
Q <- matrix(c(0.8, 0.3, 0.2, 0.7),2,2) 
set.seed(1)
u <-runif(250)
mu <- c(-0.3 ,0.7) 
sigma <- c(0.15,0.05);
eta0=1
x <- SimHMMGaussianInv(u,mu,sigma,Q,eta0)

}
\references{
Nasri & Remillard (2019). Copula-based dynamic models for multivariate time series. JMVA, vol. 172, 107--121.
}
\author{
Bouchra R Nasri  and Bruno N Rémillard, January 31, 2019
}
