% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detection_probability_functions.R
\name{summary.gGeneric}
\alias{summary.gGeneric}
\title{Summarize the gGeneric list to a simple table}
\usage{
\method{summary}{gGeneric}(object, ..., CL = 0.9)
}
\arguments{
\item{object}{gGeneric output list (each element is a named vector of 
gGeneric values for a cell in the model combinations)}

\item{...}{arguments to be passed down}

\item{CL}{confidence level}
}
\value{
a summary table of g values (medians and confidence bounds) for 
  each cell combination within the gGeneric list
}
\description{
methods for \code{summary} applied to a \code{gGeneric} list
}
\examples{
  data(mock)
  model_SE <- pkm(formula_p = p ~ HabitatType, formula_k = k ~ 1,
                data = mock$SE)
  model_CP <- cpm(formula_l = l ~ Visibility, formula_s = s ~ Visibility, 
                data = mock$CP, left = "LastPresentDecimalDays", 
                right = "FirstAbsentDecimalDays")
  avgSS <- averageSS(mock$SS)
  ghatsGeneric <- estgGeneric(nsim = 1000, avgSS, model_SE, model_CP)
  summary(ghatsGeneric)

}
