% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searcher_efficiency_functions.R
\name{qpk}
\alias{qpk}
\title{Quantiles of marginal distributions of \eqn{\hat{p}} and \eqn{\hat{k}}}
\usage{
qpk(p, model)
}
\arguments{
\item{p}{vector of probabilities}

\item{model}{A \code{\link{pkm}} object (which is returned from
\code{pkm()})}
}
\value{
either a list of \code{ncell} \eqn{\times} \code{length(p)} matrices
 of quantiles for \code{$p} and \code{$k} for cells defined by the
 \code{model} object (if \code{model$pOnly == FALSE}) or a \code{ncell}
 \eqn{\times} \code{length(p)} matrix of quantiles for \code{p}
}
\description{
Calculate quantiles of marginal distributions of \eqn{\hat{p}}
 and \eqn{\hat{k}} for a \code{\link{pkm}} model object
}
\examples{
 # 90\% confidence intervals for \code{p} and \code{k}
  mod <- pkm(formula_p = p ~ Visibility * Season, formula_k = k ~ Season,
   data = wind_cleared$SE)
  qpk(p = c(0.05, 0.95), model = mod)

}
\seealso{
\code{\link{rpk}}, \code{\link{pkm}}
}
