% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/introns.R
\name{extract_ss_motif}
\alias{extract_ss_motif}
\title{Extract Splice Site Motifs for MaxEntScan Analysis (5' or 3')}
\usage{
extract_ss_motif(input, genome, type, verbose, save_fasta, output_file)
}
\arguments{
\item{input}{A data frame with columns: \code{seqnames}, \code{strand}, \code{intron_start}, \code{intron_end}, \code{transcript_id}, \code{intron_number}.}

\item{genome}{A BSgenome object (e.g., from BSgenome.Hsapiens.UCSC.hg38).}

\item{type}{One of \code{"5ss"} (donor) or \code{"3ss"} (acceptor).}

\item{verbose}{Logical; print progress messages.}

\item{save_fasta}{Logical; write a FASTA file of extracted motifs.}

\item{output_file}{Name/path of the output FASTA file.}
}
\value{
A data frame including extracted splice site motifs.
}
\description{
Extracts donor (5') or acceptor (3') splice site motifs from a genomic dataset using BSgenome sequences.
}
\examples{
\dontrun{
if (requireNamespace("BSgenome.Hsapiens.UCSC.hg38", quietly = TRUE)) {
  genome <- BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38
  file_v1 <- system.file("extdata", "gencode.v1.example.gtf.gz", package = "GencoDymo2")
  gtf_v1 <- load_file(file_v1)
  introns <- extract_introns(gtf_v1)
  motifs_df <- extract_ss_motif(introns, genome, "5ss", verbose = FALSE)
}
}

}
\seealso{
\code{\link{assign_splice_sites}}, \code{\link{df_to_fasta}}
}
