% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{getNMFgenes}
\alias{getNMFgenes}
\title{Get list of genes for each NMF program}
\usage{
getNMFgenes(nmf.res, method = 0.5, max.genes = 200)
}
\arguments{
\item{nmf.res}{A list of NMF models obtained using \code{multiNMF()}}

\item{method}{Parameter passed to \code{\link[NMF]{extractFeatures}} to
obtain top genes for each program. When 'method' is a number between 0 
and 1, it indicates
the minimum relative basis contribution above which the feature is
selected, i.e. how specific is a gene for a given program.}

\item{max.genes}{Max number of genes for each program}
}
\value{
Returns a list of top genes for each gene program found
    by \code{multiNMF()}
}
\description{
Run it over a list of NMF models obtained using \code{multiNMF()}
}
\examples{
library(Seurat)
data(sampleObj)
geneNMF_programs <- multiNMF(list(sampleObj), k=5)
geneNMF_genes <- getNMFgenes(geneNMF_programs)

}
