% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speeches.R
\name{germaparl_encode_speeches}
\alias{germaparl_encode_speeches}
\title{Add Annotation of Speeches to GermaParl Corpus}
\usage{
germaparl_encode_speeches(
  mc = 1L,
  progress = TRUE,
  registry_dir = cwbtools::cwb_registry_dir(),
  corpus_dir = NULL,
  sample = FALSE
)
}
\arguments{
\item{mc}{An \code{integer} value, the number of cores to use, passed into the
\code{as.speeches} function.}

\item{progress}{A \code{logical} value, whether to show a progress bar.}

\item{registry_dir}{The registry directory where the registry file for the
GERMAPARL corpus resides. By default, the function
\code{cwbtools::cwb_registry_dir} is used to guess the registry directory.
We recommend to state the registry directory explicitly.}

\item{corpus_dir}{The directory where CWB data_directories reside.}

\item{sample}{A \code{logical} value, if \code{FALSE}, enrich "GERMAPARL",
enrich "GERMAPARLSAMPLE" if \code{TRUE}.}
}
\value{
A \code{data.table} with the regions of speeches and speech ids is
  returned invisibly. The function is usually called for its side
  effects, i.e. adding the structural annotation of speeches to the corpus.
}
\description{
The basic text unit in the \emph{GermaParl} corpus are units of uninterrupted
speech. Speeches are interrupted by interjections, remarks of the presidency,
and questions from the Bundestag plenary. The heuristic of the
\code{as.speeches}-function from the \code{polmineR} package can be used to
generate subcorpora with speeches. This function will call \code{as.speeches}
and write back the finding as a structural attribute to the indexed
\emph{GermaParl} corpus.
}
\details{
For encoding the structural attribute, the \code{s_attribute_encode} from the
\code{cwbtools} package is used.
}
\seealso{
The workflow to add an annotation of speeches is part of the
  examples section of the overview documentation of the \link{GermaParl}
  package.
}
