% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gitrd_utils.R
\name{gitrd.convert.to.wide}
\alias{gitrd.convert.to.wide}
\title{Converts a dataframe from gitr_GetITRData to the wide format}
\usage{
gitrd.convert.to.wide(data.in, data.in.cols = "original")
}
\arguments{
\item{data.in}{Data frame with financial information}

\item{data.in.cols}{Which data to go in rows values ('original' or 'inflation adjusted')}
}
\value{
A dataframe in the wide format
}
\description{
Converts a dataframe from gitr_GetITRData to the wide format
}
\examples{

# get example data from RData file
my.f <- system.file('extdata/ExampleReport_Petrobras.RData', package = 'GetITRData')
load(my.f)

df.assets <- df.reports$fr.assets[[1]]
df.assets.wide <- gitrd.convert.to.wide(df.assets)
}
