% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_issues.R
\name{get_issues_stats}
\alias{get_issues_stats}
\title{Get issues statistics}
\usage{
get_issues_stats(
  issues,
  time_aggregation = c("year", "month", "week", "day"),
  group_var
)
}
\arguments{
\item{issues}{A \code{gitstats_issue} S3 class table object (output of \code{get_issues()}).}

\item{time_aggregation}{A character, specifying time aggregation of
statistics.}

\item{group_var}{Other grouping variable to be passed to \code{dplyr::group_by()}
function apart from \code{stats_date} and \code{githost}. Could be: \code{author},
\code{state} or \code{organization}. Should be passed without
quotation marks.}
}
\value{
A table of \code{issues_stats} class.
}
\description{
Prepare statistics from the pulled issues data.
}
\details{
To make function work, you need first to get issues data with
\code{GitStats}. See examples section.
}
\examples{
\dontrun{
 my_gitstats <- create_gitstats() \%>\%
   set_github_host(
     token = Sys.getenv("GITHUB_PAT"),
     repos = c("r-world-devs/GitStats", "openpharma/visR")
   ) |>
   get_issues(my_gitstats, since = "2022-01-01") |>
   get_issues_stats(
     time_aggregation = "month",
     group_var = state
   )
}
}
