% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distRandCum.R
\name{distRandCum}
\alias{distRandCum}
\title{R function to test the significance of the spatial relationship between two features in terms of
the cumulative distribution of minimum distances}
\usage{
distRandCum(
  from.feat,
  to.feat,
  studyplot = NULL,
  buffer = 0,
  B = 200,
  type = "rand"
)
}
\arguments{
\item{from.feat}{Feature (of point type; SpatialPointsDataFrame class) whose spatial association
with the to-feature has to be assessed.}

\item{to.feat}{Feature (point, polyline, or polygon type; SpatialPointsDataFrame,
SpatialLinesDataFrame, SpatialPolygonsDataFrame class) in relation to which the spatial
association of the from-feature has to be assessed.}

\item{studyplot}{Feature (of polygon type; SpatialPolygonsDataFrame class) representing the
study area; if not provided, the study area is internally worked out as the bounding polygon
based on the union the convex hulls of the from- and of the to-feature.}

\item{buffer}{Add a buffer to the convex hull of the study area (0 by default); the unit depends
upon the units of the input data.}

\item{B}{Number of randomizations to be used (200 by default).}

\item{type}{By default is set to "rand", which performs the randomization-based analysis; if
both the from.feature and the to.feature dataset are of point type, setting the parameter to
"perm" allows to opt for the permutation-based approach.}
}
\value{
The function produces a cumulative distribution chart in which the distribution of the
observed minimum distances is represented by a black line, and acceptance interval is represented
in grey. The number of iteration used and the type of analysis (whether randomization-based or
permutation-based) are reported in the chart's title.
}
\description{
The function allows to assess if there is a significant spatial association between a point
pattern and the features of another pattern. For instance, users may want to assess if the
features of a point pattern tend to lie close to some features represented by polylines.\cr
}
\details{
Given a from-feature (event for which we want to estimate the spatial association with the
to-feature) and a to-feature (event in relation to which we want to estimate the spatial
association for the from-feature), the assessment is performed by means of a randomized
procedure:\cr

-keeping fixed the location of the to-feature, random from-features are drawn B times (the number
of randomized from-features is equal to the number of observed from-features);\cr -for each draw,
the minimum distance to the to-features is calculated; if the to-feature is made up of polygons,
the from-features falling within a polygon will have a distance of 0;\cr -a cumulative
distribution of random minimum distances is thus obtained;\cr -the cumulative random minimum
distances are used to work out an acceptance interval (with significance level equal to 0.05;
sensu Baddeley et al., "Spatial Point Patterns. Methodology and Applications with R", CRC Press
2016, 208) that allows to assess the statistical significance of the cumulative distribution of
the observed minimum distances, and that is built using the above-mentioned B realizations of a
Complete Spatial Random process.\cr

The from-feature must be a point feature, whilst the to-feature can be a point or a polyline or a
polygon feature.\cr

The rationale of the procedure is that, if there indeed is a spatial association between the two
features, the from-feature should be closer to the to-feature than randomly generated
from-features. If the studyplot shapefile is not provided, the random locations are drawn within
a bounding polygon based on the union the convex hulls of the from- and of the to-feature.\cr

If both the from-feature and the to-feature are of point type (SpatialPointsDataFrame class), the
user may opt for the randomized procedure described above (parameter 'type' set to 'rand'), or
for a permutation-based procedure (parameter 'type' set to 'perm'). Unlike the procedure
described above, whereby random points are drawn within the study area, the permutation-based
routine builds a cumulative distribution of minimum distances keeping the points location
unchanged and randomly assigning the points to either of the two patterns. The re-assignment is
performed B times (200 by default) and each time the minimum distance is calculated.\cr

For an example of the use of the analysis, \strong{see} for instance Carrero-Pazos, M. (2018).
Density, intensity and clustering patterns in the spatial distribution of Galician megaliths (NW
Iberian Peninsula). Archaeological and Anthropological Sciences.
https://doi.org/10.1007/s12520-018-0662-2, fig. 6.\cr
}
\examples{
data(springs)

data(faults)

#perform the analysis using 25 iterations and
#the default randomization-based approach
distRandCum(from.feat=springs, to.feat=faults, B=5)

data("malta_polyg") # load a sample polygon

#perform the analysis; since both patterns are of point type but the 'type' parameter is left
#in its default value ('rand'), the randomization-based approach is used
distRandCum(springs, points, studyplot=malta_polyg, B=5)

#same as above, but using the permutation-based approach
distRandCum(springs, points, studyplot=malta_polyg, type="perm", B=5)

}
\seealso{
\code{\link{distRandSign}}
}
\keyword{distRandCum}
