% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{fit_model}
\alias{fit_model}
\title{Estimate mean and covariance parameters}
\usage{
fit_model(y, locs, X = NULL, covfun_name = "matern_isotropic",
  silent = FALSE, group = TRUE, reorder = TRUE)
}
\arguments{
\item{y}{response vector}

\item{locs}{matrix of locations. Each row is a single spatial or spatial-temporal
location. If using one of the "matern_sphere" covariance functions,
the locations should be longitudes and latitudes (in that order) in degrees.}

\item{X}{design matrix. Each row contains covariates for the corresponding
observation in \code{y}. If not specified, the function sets \code{X} to be a 
matrix with a single column of ones, that is, a constant mean function.}

\item{covfun_name}{string name of a covariance function. Currently supported
are "matern_isotropic", "matern_sphere", and "matern_sphere_time".}

\item{silent}{TRUE/FALSE for whether to print some information during fitting.}

\item{group}{TRUE/FALSE for whether to use the grouped version of 
the approximation (Guinness, 2018) or not.  The grouped version 
is used by default.}

\item{reorder}{TRUE/FALSE indicating whether maxmin ordering should be used
(TRUE) or whether no reordering should be done before fitting (FALSE).}
}
\value{
A list object containing covariance parameter estimates,
mean parameter estimates, and covariance matrix for mean parameter estimates.
}
\description{
Given a response, set of locations, (optionally) a design matrix, 
and a specified covariance function, return the maximum
approximate likelihood estimates, using Vecchia's 
likelihood approximation.
}
\details{
The \code{fit_model} is a user-friendly model fitting function
that automatically performs many of the auxiliary tasks needed for 
using Vecchia's approximation, including reordering, computing
nearest neighbors, grouping, and optimization. Optimization proceeds
in several steps, using increasingly accurate versions of the approximation. 
The first step using 5 neighbors, then 15 neighbors, and the last step
uses 30 neighbors. The actual number of neighbors in the grouped
version is guaranteed to be larger, though depends on the ordering and
the configuration of the locations. We recommend always using
\code{group = TRUE} since the grouping is guaranteed to improve
the approximation.

The Jason-3 windspeed vignette is a useful source for a 
use-case of the \code{fit_model} function for data on sphere. The example below
shows a very small example with a simulated dataset in 2d.
}
\examples{
n1 <- 10
n2 <- 10
n <- n1*n2
locs <- as.matrix( expand.grid( (1:n1)/n1, (1:n2)/n2 ) )
covparms <- c(2,0.1,1/2,0)
y <- 7 + fast_Gp_sim(covparms, "matern_isotropic", locs)
X <- as.matrix( rep(1,n) )
fit <- fit_model(y, locs, X, "matern_isotropic")
fit


}
