% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vecchia_loglik_grouped}
\alias{vecchia_loglik_grouped}
\title{Grouped Vecchia's approximation to the Gaussian loglikelihood}
\usage{
vecchia_loglik_grouped(covparms, covfun_name, y, locs, NNlist)
}
\arguments{
\item{covparms}{A vector of covariance parameters appropriate
for the specified covariance function}

\item{covfun_name}{One of "matern_isotropic", "matern_space_time", "matern_sphere", 
or "matern_sphere_time".
"matern_isotropic" and "matern_sphere" have four covariance parameters, 
(variance, range, smoothness, nugget), while "matern_space_time" and 
"matern_sphere_time" have five,
(variance, spatial range, temporal range, smoothness, nugget). 
For more details, see the documentation 
for each of the covariance functions by typing, for example, ?matern_isotropic
or ?matern_sphere_time.}

\item{y}{vector of response values}

\item{locs}{matrix of locations. Row \code{i} of locs specifies the location
of element \code{i} of \code{y}, and so the length of \code{y} should equal
the number of rows of \code{locs}.}

\item{NNlist}{A list with grouped neighbor information. 
Usually the output from \code{group_obs(NNarray)}.}
}
\value{
grouped version of Vecchia's approximation to the Gaussian loglikelihood
}
\description{
This function returns the grouped version (Guinness, 2018) of 
Vecchia's (1988) approximation to the Gaussian
loglikelihood. The approximation modifies the ordered conditional
specification of the joint density; rather than each term in the product
conditioning on all previous observations, each term conditions on
a small subset of previous observations.
}
\examples{
n1 <- 40
n2 <- 40
n <- n1*n2
locs <- as.matrix( expand.grid( (1:n1)/n1, (1:n2)/n2 ) )
covparms <- c(2, 0.2, 0.75, 0)
y <- fast_Gp_sim(covparms, "matern_isotropic", locs, 50 ) 
ord <- order_maxmin(locs)
NNarray <- find_ordered_nn(locs,20)
NNlist <- group_obs(NNarray)
loglik <- vecchia_loglik_grouped( covparms, "matern_isotropic", y, locs, NNlist )
}
