% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vecchia_grouped_profbeta_loglik_grad_info}
\alias{vecchia_grouped_profbeta_loglik_grad_info}
\title{Grouped Vecchia loglikelihood, gradient, Fisher information}
\usage{
vecchia_grouped_profbeta_loglik_grad_info(
  covparms,
  covfun_name,
  y,
  X,
  locs,
  NNlist
)
}
\arguments{
\item{covparms}{A vector of covariance parameters appropriate
for the specified covariance function}

\item{covfun_name}{See \code{\link{GpGp}} for information about covariance
functions.}

\item{y}{vector of response values}

\item{X}{Design matrix of covariates. Row \code{i} of \code{X} contains
the covariates for the observation at row \code{i} of \code{locs}.}

\item{locs}{matrix of locations. Row \code{i} of \code{locs} specifies the location
of element \code{i} of \code{y}, and so the length of \code{y} should equal
the number of rows of \code{locs}.}

\item{NNlist}{A neighbor list object, the output from \code{\link{group_obs}}.}
}
\value{
a list containing
\itemize{
    \item \code{loglik}: the loglikelihood
    \item \code{grad}: gradient with respect to covariance parameters
    \item \code{info}: Fisher information for covariance parameters
    \item \code{betahat}: profile likelihood estimate of regression coefs
    \item \code{betainfo}: information matrix for \code{betahat}.
}
The covariance
matrix for \code{$betahat} is the inverse of \code{$betainfo}.
}
\description{
This function returns a grouped version (Guinness, 2018) of Vecchia's (1988) 
approximation to the Gaussian
loglikelihood, the gradient, and Fisher information, 
and the profile likelihood estimate of the regression
coefficients. The approximation modifies the ordered conditional
specification of the joint density; rather than each term in the product
conditioning on all previous observations, each term conditions on
a small subset of previous observations.
}
\examples{
n1 <- 20
n2 <- 20
n <- n1*n2
locs <- as.matrix( expand.grid( (1:n1)/n1, (1:n2)/n2 ) )
X <- cbind(rep(1,n),locs[,2])
covparms <- c(2, 0.2, 0.75, 0)
y <- fast_Gp_sim(covparms, "matern_isotropic", locs, 50 )
ord <- order_maxmin(locs)
NNarray <- find_ordered_nn(locs,20)
NNlist <- group_obs(NNarray)
loglik <- vecchia_grouped_profbeta_loglik_grad_info( 
    covparms, "matern_isotropic", y, X, locs, NNlist )
}
