/*
 * Decompiled with CFR 0.152.
 */
package OptimalExperimentalDesign;

import ExperimentalDesign.AllExperimentalDesigns;
import ExperimentalDesign.Tools;
import ObjectiveFunctions.AbsSumObjective;
import ObjectiveFunctions.MahalObjective;
import ObjectiveFunctions.ObjectiveFunction;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;

public class OptimalExperimentalDesign
extends AllExperimentalDesigns {
    private static final double NOT_REACHED_YET = -999999.0;
    private static final int BATCH_SIZE = 100000;
    private static HashMap<Integer, ArrayList<BitSet>> all_indicTs = new HashMap();
    private int max_designs;
    private int n_over_two;
    private double[] objective_vals;
    private int d_opt;

    public static void main(String[] stringArray) throws Exception {
        for (int i = 1; i <= 1; ++i) {
            OptimalExperimentalDesign optimalExperimentalDesign = new OptimalExperimentalDesign();
            optimalExperimentalDesign.rand_obj.setSeed(1984L);
            int n = 6;
            int n2 = i;
            optimalExperimentalDesign.setNandP(n, n2);
            for (int j = 0; j < n; ++j) {
                double[] dArray = new double[n2];
                for (int k = 0; k < n2; ++k) {
                    dArray[k] = optimalExperimentalDesign.rand_obj.nextDouble();
                }
                optimalExperimentalDesign.setDataRow(j, dArray);
            }
            optimalExperimentalDesign.setObjective("abs_sum_diff");
            optimalExperimentalDesign.setNumCores(3);
            optimalExperimentalDesign.setWait();
            optimalExperimentalDesign.beginSearch();
        }
    }

    @Override
    public void beginSearch() {
        int n;
        super.beginSearch();
        this.initializeStartingIndicTs();
        this.objective_vals = new double[this.max_designs];
        for (n = 0; n < this.max_designs; ++n) {
            this.objective_vals[n] = -999999.0;
        }
        for (n = 0; n < this.max_designs; n += 100000) {
            final int n2 = n;
            this.search_thread_pool.execute(new Runnable(){

                @Override
                public void run() {
                    int n = Math.min(OptimalExperimentalDesign.this.max_designs, n2 + 100000);
                    for (int i = n2; i < n; ++i) {
                        if (i % 1000000 == 0) {
                            System.out.println("million");
                        }
                        ObjectiveFunction objectiveFunction = null;
                        if (OptimalExperimentalDesign.this.objective.equals("mahal_dist")) {
                            objectiveFunction = new MahalObjective(OptimalExperimentalDesign.this.Sinv, OptimalExperimentalDesign.this.n);
                        } else if (OptimalExperimentalDesign.this.objective.equals("abs_sum_diff")) {
                            objectiveFunction = new AbsSumObjective();
                        }
                        BitSet bitSet = (BitSet)((ArrayList)all_indicTs.get(OptimalExperimentalDesign.this.n)).get(i);
                        int[] nArray = Tools.convert_bitvector_to_intvector(bitSet, OptimalExperimentalDesign.this.n);
                        int[] nArray2 = Tools.findIndicies(nArray, OptimalExperimentalDesign.this.n_over_two, 1);
                        int[] nArray3 = Tools.findIndicies(nArray, OptimalExperimentalDesign.this.n - OptimalExperimentalDesign.this.n_over_two, 0);
                        ArrayList<double[]> arrayList = Tools.subsetMatrix(OptimalExperimentalDesign.this.X, nArray2);
                        ArrayList<double[]> arrayList2 = Tools.subsetMatrix(OptimalExperimentalDesign.this.X, nArray3);
                        double[] dArray = Tools.colAvg(arrayList, OptimalExperimentalDesign.this.p);
                        double[] dArray2 = Tools.colAvg(arrayList2, OptimalExperimentalDesign.this.p);
                        objectiveFunction.setXTbar(dArray);
                        objectiveFunction.setXCbar(dArray2);
                        ((OptimalExperimentalDesign)OptimalExperimentalDesign.this).objective_vals[i] = objectiveFunction.calc(false);
                        if (OptimalExperimentalDesign.this.search_stopped) break;
                    }
                }
            });
        }
        this.afterBeginSearch();
        this.d_opt = Tools.min_index(this.objective_vals);
        System.out.println("size of space: " + this.max_designs);
        System.out.println("d_opt: " + (this.d_opt + 1));
        System.out.println("obj_opt: " + this.objective_vals[this.d_opt]);
        System.out.println("time elapsed in sec: " + this.timeElapsedInSeconds());
    }

    private void initializeStartingIndicTs() {
        if (all_indicTs.containsKey(this.n)) {
            this.max_designs = all_indicTs.get(this.n).size();
            return;
        }
        System.out.println("begin initializeStartingIndicTs");
        this.max_designs = (int)this.n_choose_k(this.n, this.n / 2);
        System.out.println("max_designs " + this.max_designs);
        all_indicTs.put(this.n, new ArrayList(this.max_designs));
        this.recursivelyFindAllBinaryVecs(new BitSet(), 0, 0, 0);
        System.out.println("end initializeStartingIndicTs");
    }

    private void recursivelyFindAllBinaryVecs(BitSet bitSet, int n, int n2, int n3) {
        if (n == this.n) {
            all_indicTs.get(this.n).add(bitSet);
            if (all_indicTs.size() % 1000000 == 0) {
                System.out.println("million");
            }
            return;
        }
        BitSet bitSet2 = (BitSet)bitSet.clone();
        bitSet2.set(n, true);
        if (n2 + 1 <= this.n_over_two) {
            this.recursivelyFindAllBinaryVecs(bitSet2, n + 1, n2 + 1, n3);
        }
        BitSet bitSet3 = (BitSet)bitSet.clone();
        bitSet3.set(n, false);
        if (n3 + 1 <= this.n_over_two) {
            this.recursivelyFindAllBinaryVecs(bitSet3, n + 1, n2, n3 + 1);
        }
    }

    private long n_choose_k(int n, int n2) {
        long l = (long)Math.ceil(Math.exp(this.ln_factorial(n) - this.ln_factorial(n2) - this.ln_factorial(n - n2)));
        return l;
    }

    private double ln_factorial(int n) {
        double d = 0.0;
        for (int i = 1; i <= n; ++i) {
            d += Math.log(i);
        }
        return d;
    }

    private int num_vectors_checked() {
        int n = 0;
        if (this.objective_vals != null) {
            for (int i = 0; i < this.max_designs && this.objective_vals[i] != -999999.0; ++i) {
                ++n;
            }
        }
        return n;
    }

    public double progress() {
        return (double)this.num_vectors_checked() / (double)this.objective_vals.length;
    }

    public double[] getObjectiveVals() {
        int n = this.num_vectors_checked();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.objective_vals[i];
        }
        return dArray;
    }

    public double getOptObjectiveVal() {
        return this.objective_vals[this.d_opt];
    }

    public int[] getOptIndicT() {
        return Tools.convert_bitvector_to_intvector(all_indicTs.get(this.n).get(this.d_opt), this.n);
    }

    @Override
    public void setNandP(int n, int n2) throws Exception {
        super.setNandP(n, n2);
        this.n_over_two = n / 2;
    }
}

