/*
 * Decompiled with CFR 0.152.
 */
package KarpExperimentalDesign;

import ExperimentalDesign.Tools;
import ObjectiveFunctions.AbsSumObjective;
import java.util.ArrayList;
import java.util.LinkedList;

public abstract class KarpDesignSearcher {
    protected Integer[] indicT;
    protected int n;
    protected LinkedList<ObsBundle> obs_bundles;
    protected double[][] Xstd;
    protected static final int FIRST_ALLOCATION = 1;

    public KarpDesignSearcher(double[][] dArray) {
        int n;
        int n2;
        this.Xstd = dArray;
        this.n = dArray.length;
        this.obs_bundles = new LinkedList();
        for (n2 = 0; n2 < this.n; ++n2) {
            this.obs_bundles.add(new ObsBundle(dArray[n2][0], n2));
        }
        this.indicT = new Integer[this.n];
        n2 = 1;
        while (true) {
            this.sortObsBundles();
            System.out.println("\n\niter " + n2 + " size of obs_bundles: " + this.obs_bundles.size() + "  ===========================================================================================================");
            for (n = 0; n < this.obs_bundles.size(); ++n) {
                System.out.println("  BUNDLE #" + (n + 1));
                this.obs_bundles.get(n).print("    ");
            }
            this.mergeFirstTwoObsBundles();
            if (this.obs_bundles.size() == 1) break;
            ++n2;
        }
        System.out.println("\n\niter FINAL size of obs_bundles: " + this.obs_bundles.size() + "  ===========================================================================================================");
        for (n = 0; n < this.obs_bundles.size(); ++n) {
            System.out.println("  BUNDLE #" + (n + 1));
            this.obs_bundles.get(n).print("    ");
        }
    }

    protected abstract void sortObsBundles();

    protected void mergeFirstTwoObsBundles() {
        ObsBundle obsBundle = this.obs_bundles.removeFirst();
        ObsBundle obsBundle2 = this.obs_bundles.removeFirst();
        ObsBundle obsBundle3 = obsBundle.x_val >= obsBundle2.x_val ? new ObsBundle(obsBundle, obsBundle2) : new ObsBundle(obsBundle2, obsBundle);
        this.obs_bundles.addFirst(obsBundle3);
    }

    public double getObjVal() {
        int[] nArray = this.getIndicT();
        int[] nArray2 = Tools.findIndicies(nArray, 1);
        int[] nArray3 = Tools.findIndicies(nArray, 0);
        ArrayList<double[]> arrayList = Tools.subsetMatrix(this.Xstd, nArray2);
        ArrayList<double[]> arrayList2 = Tools.subsetMatrix(this.Xstd, nArray3);
        double[] dArray = Tools.colAvg(arrayList, 1);
        double[] dArray2 = Tools.colAvg(arrayList2, 1);
        AbsSumObjective absSumObjective = new AbsSumObjective();
        absSumObjective.setXTbar(dArray);
        absSumObjective.setXCbar(dArray2);
        return absSumObjective.calc(false);
    }

    public int[] getIndicT() {
        return Tools.convertIntegerListToPrimVec(this.indicT);
    }

    public double progress() {
        return (double)(this.n - this.obs_bundles.size() + 1) / (double)this.n;
    }

    protected class ObsBundle {
        public ObsBundle home;
        public ObsBundle a;
        public ObsBundle b;
        public Double x_val;
        public Integer indicT_index;

        public ObsBundle(Double d, Integer n) {
            this.x_val = d;
            this.indicT_index = n;
        }

        public ObsBundle(ObsBundle obsBundle, ObsBundle obsBundle2) {
            this.a = obsBundle;
            obsBundle.home = this;
            this.b = obsBundle2;
            obsBundle2.home = this;
            if (obsBundle.simple() && obsBundle.allocationNotSet()) {
                obsBundle.allocate(1);
            }
            if (obsBundle2.simple() && obsBundle2.allocationNotSet()) {
                obsBundle2.allocate(0);
            } else {
                obsBundle2.flipAllocation();
            }
            this.x_val = this.updateXVal();
        }

        private void allocate(int n) {
            KarpDesignSearcher.this.indicT[this.indicT_index.intValue()] = n;
        }

        private boolean simple() {
            return this.a == null && this.b == null;
        }

        private boolean allocationNotSet() {
            return KarpDesignSearcher.this.indicT[this.indicT_index] == null;
        }

        public void flipAllocation() {
            if (this.simple()) {
                if (this.allocationNotSet()) {
                    this.allocate(1);
                } else {
                    this.allocate(1 - KarpDesignSearcher.this.indicT[this.indicT_index]);
                }
            } else {
                ObsBundle obsBundle = this.a;
                this.a = this.b;
                this.b = obsBundle;
            }
            if (this.a != null) {
                this.a.flipAllocation();
            }
            if (this.b != null) {
                this.b.flipAllocation();
            }
        }

        private double updateXVal() {
            if (!this.simple()) {
                this.x_val = this.a.simple() && this.b.simple() ? Double.valueOf(KarpDesignSearcher.this.indicT[this.a.indicT_index] == 1 ? this.a.updateXVal() - this.b.updateXVal() : this.b.updateXVal() - this.a.updateXVal()) : Double.valueOf(this.a.updateXVal() + this.b.updateXVal());
            }
            return this.x_val;
        }

        public int size() {
            if (this.a == null && this.b == null) {
                return 1;
            }
            if (this.a == null) {
                return 1 + this.b.size();
            }
            if (this.b == null) {
                return 1 + this.a.size();
            }
            return this.a.size() + this.b.size();
        }

        public void print(String string) {
            System.out.print(string + "x_val = " + this.x_val);
            if (this.indicT_index != null && KarpDesignSearcher.this.indicT[this.indicT_index] != null) {
                System.out.print("  [" + (KarpDesignSearcher.this.indicT[this.indicT_index] == 1 ? "Treatment]" : "Control]") + "\n");
            } else {
                System.out.print("\n");
            }
            if (this.a != null) {
                this.a.print(string + "  (a) ");
            }
            if (this.b != null) {
                this.b.print(string + "  (b) ");
            }
        }
    }
}

