import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

import javax.swing.JOptionPane;
import javax.swing.JPasswordField;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.Session;

public class Ssh {
	//String hostname = "lara.getmyip.com";
	String hostname;
	String username;
	/**
	 * @param args
	 */
	private BufferedReader in=null;
	private BufferedReader inErr=null;
	private InputStream sIn;
	private InputStream sInErr;
	private OutputStream outs;
	private BufferedWriter out;
	private Session sess;
	private Connection conn;
	private SCPClient scp;
	
	class RemoteOutput extends Thread
	{
		
		public void run()
		{
			try
			{
				while(in==null)
					Thread.sleep(100);
				
				String ret;
				while (true)
				{
					ret = in.readLine();
					if (ret==null)
						return;
					//Process output
					
					System.out.println(ret);
				}
			}
			catch(IOException e){
				System.out.println("Output closed");
			}
			catch (Exception e)
			{
				System.out.println("error in RemoteOutput");
				e.printStackTrace();
			}
		}
	}
	
	class RemoteErr extends Thread
	{
		
		public void run()
		{
			try
			{
				while(in==null)
					Thread.sleep(100);
				
				String ret;
				while (true)
				{
					ret = inErr.readLine();
					if (ret==null)
						return;
					System.err.println(ret);
				}
			}
			catch (Exception e)
			{
			}
			finally{
				try {
					if(inErr!=null)
						inErr.close();
					if(sInErr!=null)
						sInErr.close();
				}
				catch(IOException e){
					System.out.println("Output closed");
				}
				catch (Exception e) {
					System.out.println("cannot close Streams");
				}
			}
		}
	}
	
	
	public BufferedReader getRemoteOutputReader(){
		return in;
	}
	
	public void connect(){

		// get server
		hostname = JOptionPane.showInputDialog(
                "Enter server",
                "grid-node4");
		
		
		//get username
		username = JOptionPane.showInputDialog(
                "Enter username",
                "");
		
		//get password
		JPasswordField passwordField = new JPasswordField(10);
        passwordField.setEchoChar('*');
        passwordField.setEnabled(true);
        passwordField.requestFocusInWindow();
        JOptionPane.showMessageDialog(
                null,
                passwordField,
                "Enter password",
                JOptionPane.OK_OPTION);
        
		String password = new String(passwordField.getPassword());
		
		try
		{
			/* Create a connection instance */

			conn = new Connection(hostname);

			/* Now connect */

			conn.connect();
			
			/* Authenticate.
			 * If you get an IOException saying something like
			 * "Authentication method password not supported by the server at this stage."
			 * then please check the FAQ.
			 */

			boolean isAuthenticated = conn.authenticateWithPassword(username, password);

			if (isAuthenticated == false){
				throw new IOException("Authentication failed");
			}
			scp =conn.createSCPClient();
			/* Create a session */

			sess = conn.openSession();

			int x_width = 900;
			int y_width = 30;

			sess.requestPTY("dumb", x_width, y_width, 0, 0, null);
			sess.startShell();
			
			sIn = sess.getStdout();
			sInErr = sess.getStderr();
			in = new BufferedReader(new InputStreamReader(sIn));
			inErr = new BufferedReader(new InputStreamReader(sInErr));
			
			outs = sess.getStdin();
			out = new BufferedWriter(new OutputStreamWriter(outs));
			
			out.write("R\n");
			out.flush();
			
			
			//start remote stdout & err printer 
			new RemoteOutput().start();
			new RemoteErr().start();
			
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				System.out.println("Thread interrupted");
				e.printStackTrace();
			}

		}
		catch (IOException e)
		{
			System.err.println("if Password authentication failed: \n passwordAuthentication must be enabled on server:\n " +
			"change PasswordAuthentication to yes in /etc/ssh/sshd_config  && /etc/init.d/sshd reload");
			e.printStackTrace(System.err);
			System.exit(2);
		}
	}
	public void send(String command){
		try {
			out.write(command +"\n");
			out.flush();
		} catch (IOException e) {
			System.out.println("cannot send command");
			e.printStackTrace();
		}
	}
	public void transferFile(final String[] remoteFiles, final String localTargetDirectory){
			
			class TransferThread extends Thread
			{
				public void run()
				{
					try
					{
						//conn.addConnectionMonitor(cmon)
						//TODO transfer status?? wit ConnectionMonitor???
						scp.get(remoteFiles, localTargetDirectory);
					}
					catch (IOException e)
					{
						System.err.println("cannot transfer files, SCP exception");
						e.printStackTrace();
					}
				}
			}
			TransferThread transfer = new TransferThread();
			transfer.start();
	}
	
	
	public void quit(){
	   try {
		   System.out.println("exit");
			//exit microdc
			out.write("exit\n");
		
			//exit console
			out.write("exit\n");
			out.flush();
			//close
			if(in!=null)
				in.close();
			if(sIn!=null)
				sIn.close();
			if(out!=null)
				out.close();
			if(outs!=null)
				outs.close();
			/* Close this session */
			if(sess!=null)
				sess.close();
	
			/* Close the connection */
			if(conn!=null)
				conn.close();
		} catch (IOException e) {
			System.out.println("cannot close Streams");
		}
	}
	public static void main(String[] args){
		Ssh ssh = new Ssh();
		ssh.connect();
		InputStreamReader isr = new InputStreamReader( System.in );
	    BufferedReader stdin = new BufferedReader( isr );
	    System.out.print( "Type some data for the program");
		while(true){
			String command;
			try {
				command = stdin.readLine();
				ssh.send(command);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
		}
		
	}
	
}