import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

import javax.swing.JApplet;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.Session;


public class SshApplet extends JApplet implements ActionListener,KeyListener,TextListener {
	
	private TextField field_name;
	private TextField field_pw;
	private TextArea ta;
	private TextField tf;
	
	private String hostname = "grid-node4";
	private String username;
	private BufferedReader in=null;
	private BufferedReader inErr=null;
	private InputStream sIn;
	private InputStream sInErr;
	private OutputStream outs;
	private BufferedWriter out;
	private Session sess;
	private Connection conn;
	private SCPClient scp;
	
	public void init() {
		resize(600,300);
		setBackground(Color.white);
		Panel menu = new Panel();
		menu.setBackground(Color.lightGray);
		Label label_name = new Label("Username");
		label_name.setAlignment(Label.RIGHT);
		menu.add(label_name);
		field_name = new TextField(8);
		menu.add(field_name);
		Label label_pw = new Label("Password");
		label_pw.setAlignment(Label.RIGHT);
		menu.add(label_pw);
		field_pw = new TextField(8);
		field_pw.setEchoChar('*');
		menu.add(field_pw);
		Button bt_login = new Button("Login");
		bt_login.addActionListener(this);
		menu.add(bt_login);
		setLayout( new BorderLayout() );
		add("North",menu);
		Panel content = new Panel();
		ta = new TextArea(14,80);
		ta.setEditable(false);
		ta.setBackground(Color.black);
		ta.setForeground(Color.white);
		content.add(ta);
		tf = new TextField(80);
		tf.addKeyListener(this);
		content.add(tf);
		add("Center",content);
		
	}

	
	public void start() {
		
	}
	
	public void keyTyped(KeyEvent event) {}
	
	public void keyReleased(KeyEvent event) {}
	
	public void keyPressed(KeyEvent event) {
		int key = event.getKeyCode();
		if (key == KeyEvent.VK_ENTER) {
			//ta.append(tf.getText() + "\n");
			send(tf.getText());
			tf.setText("");
		}
	}
	
	public void textValueChanged(TextEvent event) {
		TextComponent tc = (TextComponent) event.getSource();
		String s = tc.getText();
		if (s.contains("close_connection")) {
			quit();
			ta.removeTextListener(this);
		}
	}
	
	public void actionPerformed(ActionEvent event) {
		String cmd = event.getActionCommand();
		if (cmd.equals("Login")) {
			ta.setText("");
			ta.addTextListener(this);
			connect();
		}
	}
	
	public void send(String command){
		try {
			out.write(command +"\n");
			out.flush();
		} catch (IOException e) {
			ta.append("cannot send command\n");
			e.printStackTrace();
		}
	}
	
	public void connect(){
		
		//get username
		username = field_name.getText();
		
		//get password
		String password = field_pw.getText();
		
		try
		{
			/* Create a connection instance */

			conn = new Connection(hostname);

			/* Now connect */

			conn.connect();
			
			/* Authenticate.
			 * If you get an IOException saying something like
			 * "Authentication method password not supported by the server at this stage."
			 * then please check the FAQ.
			 */

			boolean isAuthenticated = conn.authenticateWithPassword(username, password);

			if (isAuthenticated == false){
				throw new IOException("Authentication failed");
			}
			scp =conn.createSCPClient();
			/* Create a session */

			sess = conn.openSession();

			int x_width = 900;
			int y_width = 30;

			sess.requestPTY("dumb", x_width, y_width, 0, 0, null);
			sess.startShell();
			
			sIn = sess.getStdout();
			sInErr = sess.getStderr();
			in = new BufferedReader(new InputStreamReader(sIn));
			inErr = new BufferedReader(new InputStreamReader(sInErr));
			
			outs = sess.getStdin();
			out = new BufferedWriter(new OutputStreamWriter(outs));
			
			out.write("startR.sh\n");
			out.flush();
			
			
			//start remote stdout & err printer 
			new RemoteOutput().start();
			new RemoteErr().start();
			
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				ta.append("Thread interrupted\n");
				e.printStackTrace();
			}

		}
		catch (IOException e)
		{
			ta.append("if Password authentication failed: \n passwordAuthentication must be enabled on server:\n " +
			"change PasswordAuthentication to yes in /etc/ssh/sshd_config  && /etc/init.d/sshd reload\n");
			e.printStackTrace(System.err);
			System.exit(2);
		}
	}
	
	public void quit(){
		try {
			ta.append("exit\n");
			//exit microdc
			out.write("exit\n");
			
			//exit console
			out.write("exit\n");
			out.flush();
			//close
			if(in!=null) in.close();
			if(sIn!=null) sIn.close();
			if(out!=null) out.close();
			if(outs!=null) outs.close();
			/* Close this session */
			if(sess!=null) sess.close();
		
			/* Close the connection */
			if(conn!=null) conn.close();
		} catch (IOException e) {
			ta.append("cannot close Streams\n");
		}
	}
	
	class RemoteOutput extends Thread
	{
		
		public void run()
		{
			try
			{
				while(in==null)
					Thread.sleep(100);
				
				//String ret;
				while (true)
				{
					int i;
					while ((i = in.read()) != -1) {
						char c = (char) i;
						ta.append(Character.toString(c));
					}
					//ret = in.readLine();
					/*if (ret==null)
						return;*/
					//Process output
					
					//ta.append(ret + "\n");
					return;
				}
			}
			catch(IOException e){
				ta.append("Output closed\n");
			}
			catch (Exception e)
			{
				System.out.println("error in RemoteOutput");
				e.printStackTrace();
			}
		}
	}
	
	class RemoteErr extends Thread
	{
		
		public void run()
		{
			try
			{
				while(in==null)
					Thread.sleep(100);
				
				String ret;
				while (true)
				{
					ret = inErr.readLine();
					if (ret==null)
						return;
					ta.append(ret + "\n");
				}
			}
			catch (Exception e)
			{
			}
			finally{
				try {
					if(inErr!=null)
						inErr.close();
					if(sInErr!=null)
						sInErr.close();
				}
				catch(IOException e){
					ta.append("Output closed\n");
				}
				catch (Exception e) {
					ta.append("cannot close Streams\n");
				}
			}
		}
	}

}
