package de.fhg.iais.kd.gridr.interfaces;

import java.io.File;

import org.globus.ftp.GridFTPClient;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.ietf.jgss.GSSCredential;

public class GridFTPDownload {

	/**
	 * @param args
	 * args[0] url of the file to download
	 * args[1] path where to download that file, must not exist
	 */
	public static void main(String[] args) {
		if(args.length<2){
			System.err.println("wrong input arguments, usage: ip(:port)/remotepath, file");
			return;
		}
		String url=args[0];
		
		if(url==null || url.length()==0 || url.indexOf("/")==-1){
			System.err.println("wrong url format: ip(:port)/remotepath");
			return;
		}
		
		File localFile= new File(args[1]);
		
		
		if(localFile.exists()){
			System.err.println("local file exists, stopping download");
			return;
		}
		
		int hostEnd =url.lastIndexOf(":");
		int port=2811;
		String host=null;
				
		if(hostEnd>0){
			host = url.substring(0, hostEnd);
			port = Integer.parseInt(url.substring(url.lastIndexOf(":") + 1, url.indexOf("/")));
		}
		else{
			host = url.substring(0,url.indexOf("/"));
		}
			
		String remotefile = url.substring(url.indexOf("/") + 1);
		
		try{
			GridFTPClient client = new GridFTPClient(host, port);
			
			GlobusCredential gc = GlobusCredential.getDefaultCredential();
			GSSCredential credential = new GlobusGSSCredentialImpl(gc,
					GlobusGSSCredentialImpl.INITIATE_AND_ACCEPT);
			
			client.authenticate(credential);
			client.setPassiveMode(true);
			client.get(remotefile, localFile);
			
			client.close();
		}
		catch(Exception e){
			System.err.println("cannot download file: ");
			e.printStackTrace();
		}

	}

}
