% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.utility.R
\name{full.annotation.matrix}
\alias{full.annotation.matrix}
\title{Full annotation matrix}
\usage{
full.annotation.matrix(W, anc, ann.spec)
}
\arguments{
\item{W}{a symmetric adjacency weighted matrix of the graph.}

\item{anc}{the ancestor list.}

\item{ann.spec}{the annotation matrix of the most specific annotations (0/1): rows are genes and columns are terms.}
}
\value{
A full annotation table T, that is a matrix where the transitive closure of annotations is performed.
Rows correspond to genes of the weighted adjacency matrix and columns to terms.
\eqn{T[i,j]=1} means that gene \eqn{i} is annotated for the term \eqn{j}, \eqn{T[i,j]=0} means that gene \eqn{i} is not annotated for the term \eqn{j}.
}
\description{
Build a full annotations matrix using the ancestor list and the most specific annotations matrix w.r.t. a given weighted adjacency matrix (wadj).
The rows of the full annotation matrix correspond to all the examples of the given weighted adjacency matrix and the columns to the class/terms.
The transitive closure of the annotations is performed.
}
\details{
The examples present in the annotation matrix (\code{ann.spec}) but not in the adjacency weighted matrix (\code{W}) are purged.
}
\examples{
data(wadj);
data(graph);
data(labels);
anc <- build.ancestors(g);
full.ann <- full.annotation.matrix(W, anc, L);
}
