% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.woa.r
\name{extract.woa}
\alias{extract.woa}
\title{Extract temperatures from World Ocean Atlas}
\usage{
extract.woa(dir, bbox = NULL, resolution)
}
\arguments{
\item{dir}{path to load the global nc file from; specify the complete
path to the nc file unless it is in your current working directory}

\item{bbox}{bounding box of form list(long min, long max, lat min, lat max)}

\item{resolution}{indicates whether oceanographic data is gridded at 
'quarter' or 'one' degree resolution}
}
\value{
a list containing: DAT is an array of temperature data with 
  dimensions (long, lat, depth, time) depth contains 57 standard depth levels
  by default and levels are defined in variable 'depth' contained here. time 
  is monthly and spans the entire year. LON/LAT are vectors of lon/lat bounds
}
\description{
\code{extract.woa} extracts the desired temperature data from a global 
dataset derived from monthly gridded climatology data contained in the 2013 
World Ocean Atlas
}
\examples{
\dontrun{
# download WOA data (large RData file!) from GitHub
woa.dir <- paste('my_woa_dir')
get.env(type = 'woa', resol = 'quarter')

# extract desired data based on spatial bounds
woa <- extract.woa(woa.dir, bbox, 'quarter')

}

}
