% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segsmooth.R
\name{segsmooth}
\alias{segsmooth}
\title{Smoothing data using the moving average method for the homogeneous segmentation.}
\usage{
segsmooth(var = "deflection", range = 11, data)
}
\arguments{
\item{var}{A character of the name of a variable in a dataset,
such as a road pavement performance indicator.}

\item{range}{A number of the size of moving window. An odd number is required.}

\item{data}{A data frame of monitoring data.}
}
\description{
A center aligned moving window is used for the moving average method.
}
\examples{
# preprocessing
testdata <- tsdwa[1:500,]
testdata <- preprocessing(var = "Deflection", location = "SLK.start", data = testdata)
# smoothing
testdata <- segsmooth(var = "Deflection", range = 11, data = testdata)
# plot
plot(testdata$SLK.start, testdata$Deflection, type = "l",
     col = "lightblue", xlab = "location", ylab = "deflection")
lines(testdata$SLK.start, testdata$smooth.Deflection)

}
