/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.plotml;

import com.microstar.xml.XmlException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JOptionPane;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotFrame;
import ptolemy.plot.plotml.PlotBoxMLParser;
import ptolemy.plot.plotml.PlotMLParser;

public class PlotMLFrame
extends PlotFrame {
    public PlotMLFrame() {
        this("Ptolemy Plot Frame");
    }

    public PlotMLFrame(String string) {
        this(string, (PlotBox)null);
    }

    public PlotMLFrame(String string, PlotBox plotBox) {
        super(string, plotBox);
    }

    protected void _about() {
        JOptionPane.showMessageDialog(this, "Ptolemy plot frame\nBy: Edward A. Lee, eal@eecs.berkeley.edu\nand Christopher Hylands, cxh@eecs.berkeley.edu\nVersion 5.3, Build: $Id: PlotMLFrame.java,v 1.14 2003/04/11 16:16:11 cxh Exp $For more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n", "About Ptolemy Plot", 1);
    }

    protected void _read(URL uRL, InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(9);
        byte[] byArray = new byte[8];
        bufferedInputStream.read(byArray);
        bufferedInputStream.reset();
        if (new String(byArray).startsWith("<?xm")) {
            PlotBoxMLParser plotBoxMLParser = this.plot instanceof Plot ? new PlotMLParser((Plot)this.plot) : new PlotBoxMLParser(this.plot);
            try {
                plotBoxMLParser.parse(uRL, bufferedInputStream);
            }
            catch (Exception exception) {
                String string;
                if (exception instanceof XmlException) {
                    XmlException xmlException = (XmlException)exception;
                    string = "PlotMLFrame: failed to parse PlotML data:\nline: " + xmlException.getLine() + ", column: " + xmlException.getColumn() + "\nIn entity: " + xmlException.getSystemId() + "\n";
                } else {
                    string = "PlotMLFrame: failed to parse PlotML data:\n";
                }
                System.err.println(string + exception.toString());
                exception.printStackTrace();
            }
        } else {
            super._read(uRL, bufferedInputStream);
        }
    }
}

