/*
 * Decompiled with CFR 0.152.
 */
package com.microstar.xml;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class XmlException
extends Exception {
    private String _message;
    private Throwable _cause;
    private String _systemId;
    private int _line = -1;
    private int _column = -1;

    public XmlException(String string, String string2) {
        this(string, string2, -1, -1, null);
    }

    public XmlException(String string, String string2, int n, int n2) {
        this(string, string2, n, n2, null);
    }

    public XmlException(String string, String string2, int n, int n2, Throwable throwable) {
        this._message = string;
        this._systemId = string2;
        this._line = n;
        this._column = n2;
        this._cause = throwable;
    }

    public Throwable getCause() {
        return this._cause;
    }

    public String getMessage() {
        return this._message + " in " + this._systemId + (this._line == -1 ? "unknown line " : " at line " + this._line) + (this._column == -1 ? " and unknown column " : " and column " + this._column) + (this._cause == null ? "" : "\nCaused by:\n " + this._cause);
    }

    public String getSystemId() {
        return this._systemId;
    }

    public int getLine() {
        return this._line;
    }

    public int getColumn() {
        return this._column;
    }

    public void printStackTrace() {
        this.printStackTrace(new PrintWriter(System.err));
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new PrintWriter(printStream));
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this._cause != null) {
            printWriter.print("Caused by: ");
            this._cause.printStackTrace(printWriter);
        }
        printWriter.flush();
    }

    public static String stackTraceToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

