% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_coverage.R
\name{plot_coverage}
\alias{plot_coverage}
\title{Plot peptide coverage}
\usage{
plot_coverage(dat, chosen_state = dat[["State"]][1])
}
\arguments{
\item{dat}{data as imported by the \code{\link{read_hdx}} function}

\item{chosen_state}{sequence states to be included in plot}
}
\description{
Plots the peptide coverage of the protein sequence.
}
\examples{
dat <- read_hdx(system.file(package = "HaDeX", 
                            "HaDeX/data/KD_180110_CD160_HVEM.csv"))
plot_coverage(dat)
plot_coverage(dat, chosen_state = "CD160_HVEM")

}
