% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similar.R
\name{similar}
\alias{similar}
\title{Test if two vectors contains the same elements independently of their order}
\usage{
similar(x, y, test.names = FALSE)
}
\arguments{
\item{x}{A vector with numeric or string elements}

\item{y}{A vector with numeric or string elements}

\item{test.names}{Logical. If TRUE, the names of the vector elements must be also identical and unique}
}
\value{
A logical TRUE or FALSE
}
\description{
Return TRUE only if all elements of x are present and only once in y.\cr
}
\examples{
\dontrun{
A <- c("A", "B", "C", "D")
B <- c("A", "B", "C", "D")
similar(A, B)
similar(B, A)
A <- c(x="A", y="B", z="C", k="D")
B <- c(x="A", y="B", z="C", l="D")
similar(B, A)
similar(A, B, test.names=TRUE)
A <- c(x="A", y="B", z="C", k="D")
B <- c(x="A", z="C", k="D", y="B")
similar(B, A)
similar(A, B, test.names=TRUE)
}
}
\author{
Marc Girondot
}
