#' logLik.compareAIC Return Log Likelihood of a fit
#' @title Return Log Likelihood generated by FormatCompareAIC
#' @author Marc Girondot
#' @return The Log Likelihood value for the fitted model with data
#' @param object A result generated by FormatCompareAIC
#' @param ... Not used
#' @description Return Log Likelihood generated by FormatCompareAIC
#' @family AIC functions
#' @examples
#' \dontrun{
#' ED <- FormatCompareAIC(logLik=-140, nobs=100, df=3)
#' logLik(ED)
#' }
#' @method logLik compareAIC
#' @export


logLik.compareAIC <- function(object, ...) {
  l <- object$logLik
  attributes(l) <- list(nall=attributes(object)$nall, 
                                                  nobs=attributes(object)$nobs, 
                                                  df=attributes(object)$df)
    return(l)
}
