% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Met_distributionH.R
\docType{methods}
\name{rQQ}
\alias{rQQ}
\alias{rQQ,distributionH,distributionH-method}
\alias{rQQ,distributionH-method}
\title{Method \code{rQQ}}
\usage{
rQQ(e1, e2)

\S4method{rQQ}{distributionH,distributionH}(e1, e2)
}
\arguments{
\item{e1}{A \code{distributionH} object}

\item{e2}{A \code{distributionH} object}
}
\value{
Pearson correlation index between quantiles
}
\description{
Method \code{rQQ}

Quantile-Quantile correlation between two distributions
}
\examples{

##---- initialize two distributionH object mydist1 and mydist2
 mydist1<-distributionH(x=c(1,2,3),p=c(0, 0.4, 1))
 mydist2<-distributionH(x=c(7,8,10,15),p=c(0, 0.2, 0.7, 1))
 ## computes the rQQ
 rQQ(mydist1,mydist2)
 ## OUTPUT 0.916894

}
\references{
Irpino, A., Verde, R. (2015) \emph{Basic
statistics for distributional symbolic variables: a new metric-based
approach} Advances in Data Analysis and Classification, DOI 10.1007/s11634-014-0176-4
}
\author{
Antonio Irpino
}
