% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness_of_fit.R
\name{GOF_percent_bias}
\alias{GOF_percent_bias}
\title{Calculates percent bias.}
\usage{
GOF_percent_bias(mod, obs, na.rm = TRUE)
}
\arguments{
\item{mod}{'numeric' vector. Modeled or simulated values. Must be same length as \code{obs}.}

\item{obs}{'numeric' vector. Observed or comparison values. Must be same length as \code{mod}.}

\item{na.rm}{'boolean' \code{TRUE} or \code{FALSE}. Should \code{NA} values be removed before computing. If any
\code{NA} values are present in \code{mod} or \code{obs}, the \emph{i}th position from each will be removed before
calculating. If \code{NA} values are present and \code{na.rm = FALSE}, then function will return \code{NA}.
Default is \code{TRUE}.}
}
\value{
Value of calculated percent bias as percent.
}
\description{
Calculates percent bias between modeled (simulated) and observed values.
}
\details{
Values returned are in percent.
}
\examples{
GOF_percent_bias(mod = example_mod$streamflow_cfs, obs = example_obs$streamflow_cfs)

}
\keyword{goodness-of-fit}
