% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/HydeUtilities.R
\name{HydeUtilities}
\alias{HydeUtilities}
\alias{dataframeFactors}
\alias{decisionOptions}
\alias{makeFactorRef}
\alias{makeJagsReady}
\alias{matchLevelNumber}
\alias{matchVars}
\alias{nodeFromFunction}
\alias{policyMatrixValues}
\alias{polyToPow}
\alias{termName}
\alias{validateParameters}
\title{Hyde Network Utility Functions}
\usage{
termName(term, reg)

decisionOptions(node, network)

makeJagsReady(mdl, regex, nodes)

matchLevelNumber(t, lev)

matchVars(terms, vnames)

nodeFromFunction(node_fn)

policyMatrixValues(node, network)

polyToPow(poly)

validateParameters(params, dist)

makeFactorRef(network)

dataframeFactors(dataframe)
}
\arguments{
\item{term}{Usually the \code{term} column from the output of
\code{broom::tidy()}}

\item{reg}{A regular expression, usually provided by \code{factorRegex}}

\item{node}{Character string indicating a node in a network}

\item{network}{A Hyde Network Object}

\item{mdl}{Output from \code{broom::tidy()}}

\item{regex}{A regular expression, usually returned by \code{factorRegex}}

\item{nodes}{A vector of node names, usually passed from \code{network$nodes}.}

\item{t}{Usually the \code{term_name} column generated within
\code{makeJagsReady}}

\item{lev}{usually the \code{level_value} column generated within
\code{makeJagsReady}}

\item{terms}{A vector of term names, usually from a \code{broom::tidy} object.}

\item{vnames}{A vector of term names, usually from \code{network$nodes}.}

\item{node_fn}{A character string representing a function passed in a model formula}

\item{poly}{A single term for which the polynomial components should be
converted to the JAGS pow() function.}

\item{params}{The list of parameters given in the \code{...} argument of
\code{setNode}}

\item{dist}{The JAGS distribution function name.  Appropriate names are
in the \code{FnName} column of the \code{jagsDists} data object.}

\item{dataframe}{A data frame.  The data frame will be searched for factors and
a reference table (another data frame) is returned.}
}
\description{
The functions described below are unexported functions that
  are used internally by \code{HydeNet} to prepare modify network objects
  and prepare JAGS code.
}
\details{
\code{termName}: In most model objects, factors in the model are
  represented as [variable][level].  This utility function pulls out the
  [variable] component.  This is typically called from within
  \code{makeJagsReady}.

  \code{decisionOptions}: When compiling multiple JAGS models to evaluate the
  effect of decision nodes, the options for each decision node are extracted
  by this utility.

  \code{makeJagsReady}: Manages the presence of factors in interactions and
  makes sure the proper numeric factor value is given to the JAGS code.
  This is called from within a \code{writeJagsFormula} call.

  \code{matchLevelNumber}: Assigns the correct numeric value of a level to
  a factor variable in a model.  This is called from within
  \code{makeJagsRead}.

  \code{matchVars}: Given a list of existing node names, the terms of a formula
  are matched to the node names.  This allows functions to be used in
  formula defintions.  Most commonly, \code{factor(var)} would get reduced to
  \code{var}, which is a node name that JAGS will understand.  There is still
  limited ability for translation here, and \code{matchVars} assumes that the
  longest match is the desired match. If you pass a function with two node names,
  the longer of the two will be taken and JAGS will likely fail.

  \code{nodeFromFunction}: This is a utility function necessary to make
  \code{modelToNode} work properly.  A node vector was needed to pass to
  \code{matchVars}, and this is the mechanism to generate that vector.

  \code{polyToPow}: converts polynomials generated by the \code{poly} function
  to use the \code{pow} function in JAGS.

  \code{validateParameters}: Users may pass parameters to the JAGS code using the
  \code{setNode} function.  If a faulty parameter is given, such as
  \code{lambda = -10} for a poisson distribution (\code{lambda} must be
  positive in a Poisson distribution), the error returned by JAGS may not
  clear enough to diagnose a problem that presented several steps earlier
  in the code.  \code{validateParamters} allows the user to receive instant
  feedback on the appropriateness of the code.

  Logical expressions for comparisons are stored in the \code{jagsDists}
  data object (\code{data(jagsDists, package='Hyde')}).  This is a utility
  function used only within \code{setNode} and is not visible to the user.
}
\author{
Jarrod Dalton and Benjamin Nutter
}

