context("setNode")

Net <- HydeNetwork(~ wells +
                     pe | wells +
                     d.dimer | pregnant*pe +
                     angio | pe +
                     treat | d.dimer*angio +
                     death | pe*treat,
                   data = PE)

test_that("decision argument warning",
{
  expect_warning(setNode(Net, treat, nodeType = "dbern", decision = "yes", prob = .5))
})

test_that("utility error: utilties must be deterministic and not have children",
{
  expect_error(setNode(Net, treat, nodeType = "dbern", utility = TRUE, prob =.5))
})  

test_that("validation error",
{
  expect_error(setNode(Net, treat, nodeType = "dbern", prob = 1.2))
})

test_that("fit the model for dbern",
{
  expect_silent(setNode(Net, treat, nodeType = "dbern", prob = fromData(),
                 fitModel = TRUE))
})

test_that("fit the model for dcat",
{
  expect_silent(setNode(Net, pregnant, nodeType = "dcat", pi = fromData(),
                      fitModel = TRUE))
})

test_that("fit the model for dnorm",
{
  expect_silent(setNode(Net, d.dimer, nodeType = "dnorm",
                      mean = fromData(), sd = fromData(),
                      fitModel = TRUE))
})

test_that("fit the model for dpois",
{
  carNet <- HydeNetwork(~gear | mpg + am,
                                  data = mtcars)

  expect_silent(
    setNode(carNet, gear, nodeType = "dpois", nodeFitter = "glm",
            fitterArgs = list(family = poisson),
            lambda = fromData(),
            fitModel = TRUE))
})

test_that("setNode factorLevels with non-dcat or dbern",
{
  NetLevels <- HydeNetwork(~ gear | mpg + am)
  expect_warning(
    setNode(NetLevels, am, nodeType = "dpois", 
          factorLevels = c("Automatic", "Manual"),
          lambda = 1))
})

test_that("setNode factorLevels with cpt fitter",
{
  NetLevels <- HydeNetwork( ~ gear | mpg + am)
  expect_warning(
    setNode(NetLevels, am, nodeType = "dcat",
          nodeFitter = "cpt",
          factorLevels = c("Automatic", "Manual"),
          pi = fromData()))
})

test_that("setNode factorLevels with nodeData",
{
  NetLevels <- HydeNetwork( ~ gear | mpg + am)
  expect_warning(
    setNode(NetLevels, am, nodeType = "dcat",
            nodeFitter = "cpt",
            nodeData = mtcars,
            factorLevels = c("Automatic", "Manual"),
            pi = fromData()))
})

test_that("setNode factorLevels with network data",
{
  NetLevels <- HydeNetwork( ~ gear | mpg + am, data = mtcars)
  expect_warning(
    setNode(NetLevels, am, nodeType = "dcat",
            nodeFitter = "cpt",
            factorLevels = c("Automatic", "Manual"),
            pi = fromData()))
})

test_that("setNode factorLevels as intended to be used",
{
  NetLevels <- HydeNetwork( ~ gear | mpg + am)
  expect_equal(
    setNode(NetLevels, am, nodeType = "dcat",
            factorLevels = c("Automatic", "Manual"),
            pi = vectorProbs(c(15, 25), "am"))$factorLevels,
    list(gear = NULL, mpg = NULL, am = c("Automatic", "Manual")))
})
  