% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/INDELS_related_functions.R
\name{CreateOneColIDMatrix}
\alias{CreateOneColIDMatrix}
\title{Create one column of the matrix for an indel catalog from *one* in-memory VCF.}
\usage{
CreateOneColIDMatrix(ID.vcf, SBS.vcf)
}
\arguments{
\item{ID.vcf}{An in-memory VCF as a data.frame annotated by the
  \code{\link{AddAndCheckSequenceID}} function. It must only
  contain indels and must \strong{not} contain SBSs
  (single base substitutions), DBSs, or triplet
  base substitutions, etc.

  One design decision for variant callers is the representation of "complex
  indels", e.g. mutations e.g. CAT > GC. Some callers represent this as C>G,
  A>C, and T>_. Others might represent it as CAT > CG. Multiple issues can
  arise. In PCAWG, overlapping indel/SBS calls from different callers were
  included in the indel VCFs.}

\item{SBS.vcf}{An in-memory VCF as a data frame. Because we have to work with
some PCAWG data, we will look for neighboring indels and indels adjoining
SBS. That means this functions takes an SBS VCF and an ID VCF from the same
sample.}
}
\value{
A 1-column matrix containing the mutation catalog information.
}
\description{
Create one column of the matrix for an indel catalog from *one* in-memory VCF.
}
\keyword{internal}
